/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.SerializationHelper;
import com.datastax.oss.driver.internal.core.type.UserDefinedTypeBuilder;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class DataTypeDetachableTest {
    @Mock
    private AttachmentPoint attachmentPoint;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void simple_types_should_never_be_detached() {
        for (DataType simpleType : ImmutableList.of((Object)DataTypes.INT, (Object)DataTypes.custom((String)"some.class"))) {
            Assertions.assertThat((boolean)simpleType.isDetached()).isFalse();
            Assertions.assertThat((boolean)SerializationHelper.serializeAndDeserialize(simpleType).isDetached()).isFalse();
        }
    }

    @Test
    public void manually_created_tuple_should_be_detached() {
        TupleType tuple = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.TEXT});
        Assertions.assertThat((boolean)tuple.isDetached()).isTrue();
    }

    @Test
    public void attaching_tuple_should_attach_all_of_its_subtypes() {
        TupleType tuple1 = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT});
        TupleType tuple2 = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.TEXT, tuple1});
        Assertions.assertThat((boolean)tuple1.isDetached()).isTrue();
        Assertions.assertThat((boolean)tuple2.isDetached()).isTrue();
        tuple2.attach(this.attachmentPoint);
        Assertions.assertThat((boolean)tuple1.isDetached()).isFalse();
    }

    @Test
    public void manually_created_udt_should_be_detached() {
        UserDefinedType udt = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"field1"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"field2"), DataTypes.TEXT).build();
        Assertions.assertThat((boolean)udt.isDetached()).isTrue();
    }

    @Test
    public void attaching_udt_should_attach_all_of_its_subtypes() {
        TupleType tuple = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT});
        UserDefinedType udt = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks"), CqlIdentifier.fromInternal((String)"type")).withField(CqlIdentifier.fromInternal((String)"field1"), DataTypes.INT).withField(CqlIdentifier.fromInternal((String)"field2"), (DataType)tuple).build();
        Assertions.assertThat((boolean)tuple.isDetached()).isTrue();
        Assertions.assertThat((boolean)udt.isDetached()).isTrue();
        udt.attach(this.attachmentPoint);
        Assertions.assertThat((boolean)tuple.isDetached()).isFalse();
    }

    @Test
    public void list_should_be_attached_if_its_element_is() {
        TupleType tuple = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT});
        ListType list = DataTypes.listOf((DataType)tuple);
        Assertions.assertThat((boolean)tuple.isDetached()).isTrue();
        Assertions.assertThat((boolean)list.isDetached()).isTrue();
        tuple.attach(this.attachmentPoint);
        Assertions.assertThat((boolean)list.isDetached()).isFalse();
    }

    @Test
    public void attaching_list_should_attach_its_element() {
        TupleType tuple = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT});
        ListType list = DataTypes.listOf((DataType)tuple);
        Assertions.assertThat((boolean)tuple.isDetached()).isTrue();
        Assertions.assertThat((boolean)list.isDetached()).isTrue();
        list.attach(this.attachmentPoint);
        Assertions.assertThat((boolean)tuple.isDetached()).isFalse();
    }

    @Test
    public void set_should_be_attached_if_its_element_is() {
        TupleType tuple = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT});
        SetType set = DataTypes.setOf((DataType)tuple);
        Assertions.assertThat((boolean)tuple.isDetached()).isTrue();
        Assertions.assertThat((boolean)set.isDetached()).isTrue();
        tuple.attach(this.attachmentPoint);
        Assertions.assertThat((boolean)set.isDetached()).isFalse();
    }

    @Test
    public void attaching_set_should_attach_its_element() {
        TupleType tuple = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT});
        SetType set = DataTypes.setOf((DataType)tuple);
        Assertions.assertThat((boolean)tuple.isDetached()).isTrue();
        Assertions.assertThat((boolean)set.isDetached()).isTrue();
        set.attach(this.attachmentPoint);
        Assertions.assertThat((boolean)tuple.isDetached()).isFalse();
    }

    @Test
    public void map_should_be_attached_if_its_elements_are() {
        TupleType tuple1 = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT});
        TupleType tuple2 = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.TEXT});
        MapType map = DataTypes.mapOf((DataType)tuple1, (DataType)tuple2);
        Assertions.assertThat((boolean)tuple1.isDetached()).isTrue();
        Assertions.assertThat((boolean)tuple2.isDetached()).isTrue();
        Assertions.assertThat((boolean)map.isDetached()).isTrue();
        tuple1.attach(this.attachmentPoint);
        Assertions.assertThat((boolean)map.isDetached()).isTrue();
        tuple2.attach(this.attachmentPoint);
        Assertions.assertThat((boolean)map.isDetached()).isFalse();
    }

    @Test
    public void attaching_map_should_attach_all_of_its_subtypes() {
        TupleType tuple1 = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT});
        TupleType tuple2 = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.TEXT});
        MapType map = DataTypes.mapOf((DataType)tuple1, (DataType)tuple2);
        Assertions.assertThat((boolean)tuple1.isDetached()).isTrue();
        Assertions.assertThat((boolean)tuple2.isDetached()).isTrue();
        map.attach(this.attachmentPoint);
        Assertions.assertThat((boolean)tuple1.isDetached()).isFalse();
        Assertions.assertThat((boolean)tuple2.isDetached()).isFalse();
    }
}

