/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.tracker;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.DefaultBatchType;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.cql.DefaultColumnDefinition;
import com.datastax.oss.driver.internal.core.cql.DefaultColumnDefinitions;
import com.datastax.oss.driver.internal.core.cql.DefaultPreparedStatement;
import com.datastax.oss.driver.internal.core.tracker.RequestLogFormatter;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.RawType;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RequestLogFormatterTest {
    @Mock
    private DriverContext context;
    private final ProtocolVersion protocolVersion = DefaultProtocolVersion.V4;
    private RequestLogFormatter formatter;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getCodecRegistry()).thenReturn((Object)CodecRegistry.DEFAULT);
        Mockito.when((Object)this.context.getProtocolVersion()).thenReturn((Object)this.protocolVersion);
        this.formatter = new RequestLogFormatter(this.context);
    }

    @Test
    public void should_format_simple_statement_without_values() {
        SimpleStatement statement = SimpleStatement.newInstance((String)"SELECT release_version FROM system.local");
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, false, Integer.MAX_VALUE, Integer.MAX_VALUE)).isEqualTo("[0 values] SELECT release_version FROM system.local");
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, true, Integer.MAX_VALUE, Integer.MAX_VALUE)).isEqualTo("[0 values] SELECT release_version FROM system.local");
        Assertions.assertThat((String)this.formatRequest((Request)statement, 20, false, Integer.MAX_VALUE, Integer.MAX_VALUE)).isEqualTo("[0 values] SELECT release_versi...<truncated>");
    }

    @Test
    public void should_format_simple_statement_with_positional_values() {
        SimpleStatement statement = SimpleStatement.builder((String)"UPDATE foo SET v=? WHERE k=?").addPositionalValue((Object)Bytes.fromHexString((String)"0xdeadbeef")).addPositionalValue((Object)0).build();
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, false, Integer.MAX_VALUE, Integer.MAX_VALUE)).isEqualTo("[2 values] UPDATE foo SET v=? WHERE k=?");
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, true, Integer.MAX_VALUE, Integer.MAX_VALUE)).isEqualTo("[2 values] UPDATE foo SET v=? WHERE k=? [v0=0xdeadbeef, v1=0]");
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, true, 1, Integer.MAX_VALUE)).isEqualTo("[2 values] UPDATE foo SET v=? WHERE k=? [v0=0xdeadbeef, ...<further values truncated>]");
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, true, Integer.MAX_VALUE, 4)).isEqualTo("[2 values] UPDATE foo SET v=? WHERE k=? [v0=0xde...<truncated>, v1=0]");
    }

    @Test
    public void should_format_simple_statement_with_named_values() {
        SimpleStatement statement = SimpleStatement.builder((String)"UPDATE foo SET v=:v WHERE k=:k").addNamedValue("v", (Object)Bytes.fromHexString((String)"0xdeadbeef")).addNamedValue("k", (Object)0).build();
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, false, Integer.MAX_VALUE, Integer.MAX_VALUE)).isEqualTo("[2 values] UPDATE foo SET v=:v WHERE k=:k");
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, true, Integer.MAX_VALUE, Integer.MAX_VALUE)).isEqualTo("[2 values] UPDATE foo SET v=:v WHERE k=:k [v=0xdeadbeef, k=0]");
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, true, 1, Integer.MAX_VALUE)).isEqualTo("[2 values] UPDATE foo SET v=:v WHERE k=:k [v=0xdeadbeef, ...<further values truncated>]");
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, true, Integer.MAX_VALUE, 4)).isEqualTo("[2 values] UPDATE foo SET v=:v WHERE k=:k [v=0xde...<truncated>, k=0]");
    }

    @Test
    public void should_format_bound_statement() {
        PreparedStatement preparedStatement = this.mockPreparedStatement("UPDATE foo SET v=? WHERE k=?", (Map<String, DataType>)ImmutableMap.of((Object)"v", (Object)DataTypes.BLOB, (Object)"k", (Object)DataTypes.INT));
        BoundStatement statement = preparedStatement.bind(new Object[]{Bytes.fromHexString((String)"0xdeadbeef"), 0});
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, false, Integer.MAX_VALUE, Integer.MAX_VALUE)).isEqualTo("[2 values] UPDATE foo SET v=? WHERE k=?");
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, true, Integer.MAX_VALUE, Integer.MAX_VALUE)).isEqualTo("[2 values] UPDATE foo SET v=? WHERE k=? [v=0xdeadbeef, k=0]");
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, true, 1, Integer.MAX_VALUE)).isEqualTo("[2 values] UPDATE foo SET v=? WHERE k=? [v=0xdeadbeef, ...<further values truncated>]");
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, true, Integer.MAX_VALUE, 4)).isEqualTo("[2 values] UPDATE foo SET v=? WHERE k=? [v=0xde...<truncated>, k=0]");
    }

    @Test
    public void should_format_bound_statement_with_unset_values() {
        PreparedStatement preparedStatement = this.mockPreparedStatement("UPDATE foo SET v=? WHERE k=?", (Map<String, DataType>)ImmutableMap.of((Object)"v", (Object)DataTypes.BLOB, (Object)"k", (Object)DataTypes.INT));
        BoundStatement statement = (BoundStatement)preparedStatement.bind(new Object[0]).setInt("k", 0);
        Assertions.assertThat((String)this.formatRequest((Request)statement, Integer.MAX_VALUE, true, Integer.MAX_VALUE, Integer.MAX_VALUE)).isEqualTo("[2 values] UPDATE foo SET v=? WHERE k=? [v=<UNSET>, k=0]");
    }

    @Test
    public void should_format_batch_statement() {
        SimpleStatement statement1 = SimpleStatement.builder((String)"UPDATE foo SET v=? WHERE k=?").addNamedValue("v", (Object)Bytes.fromHexString((String)"0xdeadbeef")).addNamedValue("k", (Object)0).build();
        PreparedStatement preparedStatement = this.mockPreparedStatement("UPDATE foo SET v=? WHERE k=?", (Map<String, DataType>)ImmutableMap.of((Object)"v", (Object)DataTypes.BLOB, (Object)"k", (Object)DataTypes.INT));
        BoundStatement statement2 = preparedStatement.bind(new Object[]{Bytes.fromHexString((String)"0xabcdef"), 1});
        BatchStatement batch = BatchStatement.builder((BatchType)DefaultBatchType.UNLOGGED).addStatements(new BatchableStatement[]{statement1, statement2}).build();
        Assertions.assertThat((String)this.formatRequest((Request)batch, Integer.MAX_VALUE, false, Integer.MAX_VALUE, Integer.MAX_VALUE)).isEqualTo("[2 statements, 4 values] BEGIN UNLOGGED BATCH UPDATE foo SET v=? WHERE k=?; UPDATE foo SET v=? WHERE k=?; APPLY BATCH");
        Assertions.assertThat((String)this.formatRequest((Request)batch, 20, false, Integer.MAX_VALUE, Integer.MAX_VALUE)).isEqualTo("[2 statements, 4 values] BEGIN UNLOGGED BATCH...<truncated>");
        Assertions.assertThat((String)this.formatRequest((Request)batch, Integer.MAX_VALUE, true, Integer.MAX_VALUE, Integer.MAX_VALUE)).isEqualTo("[2 statements, 4 values] BEGIN UNLOGGED BATCH UPDATE foo SET v=? WHERE k=?; UPDATE foo SET v=? WHERE k=?; APPLY BATCH [v=0xdeadbeef, k=0][v=0xabcdef, k=1]");
        Assertions.assertThat((String)this.formatRequest((Request)batch, Integer.MAX_VALUE, true, 3, Integer.MAX_VALUE)).isEqualTo("[2 statements, 4 values] BEGIN UNLOGGED BATCH UPDATE foo SET v=? WHERE k=?; UPDATE foo SET v=? WHERE k=?; APPLY BATCH [v=0xdeadbeef, k=0][v=0xabcdef, ...<further values truncated>]");
        Assertions.assertThat((String)this.formatRequest((Request)batch, Integer.MAX_VALUE, true, 2, Integer.MAX_VALUE)).isEqualTo("[2 statements, 4 values] BEGIN UNLOGGED BATCH UPDATE foo SET v=? WHERE k=?; UPDATE foo SET v=? WHERE k=?; APPLY BATCH [v=0xdeadbeef, k=0][...<further values truncated>]");
        Assertions.assertThat((String)this.formatRequest((Request)batch, Integer.MAX_VALUE, true, Integer.MAX_VALUE, 4)).isEqualTo("[2 statements, 4 values] BEGIN UNLOGGED BATCH UPDATE foo SET v=? WHERE k=?; UPDATE foo SET v=? WHERE k=?; APPLY BATCH [v=0xde...<truncated>, k=0][v=0xab...<truncated>, k=1]");
    }

    private String formatRequest(Request request, int maxQueryLength, boolean showValues, int maxValues, int maxValueLength) {
        StringBuilder builder = new StringBuilder();
        this.formatter.appendRequest(request, maxQueryLength, showValues, maxValues, maxValueLength, builder);
        return builder.toString();
    }

    private PreparedStatement mockPreparedStatement(String query, Map<String, DataType> variables) {
        ImmutableList.Builder definitions = ImmutableList.builder();
        int i = 0;
        for (Map.Entry<String, DataType> entry : variables.entrySet()) {
            definitions.add((Object)new DefaultColumnDefinition(new ColumnSpec("test", "foo", entry.getKey(), i, (RawType)RawType.PRIMITIVES.get(entry.getValue().getProtocolCode())), (AttachmentPoint)this.context));
        }
        return new DefaultPreparedStatement(Bytes.fromHexString((String)"0x"), query, DefaultColumnDefinitions.valueOf((List)definitions.build()), Collections.emptyList(), null, null, null, null, Collections.emptyMap(), null, null, null, null, null, Collections.emptyMap(), null, null, null, Integer.MIN_VALUE, null, null, false, this.context.getCodecRegistry(), this.context.getProtocolVersion(), false);
    }
}

