/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.tracker;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.datastax.oss.driver.api.core.DriverExecutionException;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.internal.core.tracker.MultiplexingRequestTracker;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.BDDMockito;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.Strict.class)
public class MultiplexingRequestTrackerTest {
    @Mock
    private RequestTracker child1;
    @Mock
    private RequestTracker child2;
    @Mock
    private Request request;
    @Mock
    private DriverExecutionProfile profile;
    @Mock
    private Node node;
    @Mock
    private Session session;
    @Mock
    private Appender<ILoggingEvent> appender;
    @Captor
    private ArgumentCaptor<ILoggingEvent> loggingEventCaptor;
    private Logger logger;
    private Level initialLogLevel;
    private final Exception error = new DriverExecutionException((Throwable)new NullPointerException());

    @Before
    public void addAppenders() {
        this.logger = (Logger)LoggerFactory.getLogger(MultiplexingRequestTracker.class);
        this.initialLogLevel = this.logger.getLevel();
        this.logger.setLevel(Level.WARN);
        this.logger.addAppender(this.appender);
    }

    @After
    public void removeAppenders() {
        this.logger.detachAppender(this.appender);
        this.logger.setLevel(this.initialLogLevel);
    }

    @Test
    public void should_register() {
        MultiplexingRequestTracker tracker = new MultiplexingRequestTracker();
        tracker.register(this.child1);
        tracker.register(this.child2);
        ((AbstractListAssert)Assertions.assertThat((Object)tracker).extracting("trackers").asList().hasSize(2)).contains(new Object[]{this.child1, this.child2});
    }

    @Test
    public void should_flatten_child_multiplexing_tracker_via_constructor() {
        MultiplexingRequestTracker tracker = new MultiplexingRequestTracker(new RequestTracker[]{new MultiplexingRequestTracker(new RequestTracker[]{this.child1, this.child2})});
        ((AbstractListAssert)Assertions.assertThat((Object)tracker).extracting("trackers").asList().hasSize(2)).contains(new Object[]{this.child1, this.child2});
    }

    @Test
    public void should_flatten_child_multiplexing_tracker_via_register() {
        MultiplexingRequestTracker tracker = new MultiplexingRequestTracker();
        tracker.register((RequestTracker)new MultiplexingRequestTracker(new RequestTracker[]{this.child1, this.child2}));
        ((AbstractListAssert)Assertions.assertThat((Object)tracker).extracting("trackers").asList().hasSize(2)).contains(new Object[]{this.child1, this.child2});
    }

    @Test
    public void should_notify_onSuccess() {
        MultiplexingRequestTracker tracker = new MultiplexingRequestTracker(new RequestTracker[]{this.child1, this.child2});
        ((RequestTracker)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onSuccess(this.request, 123456L, this.profile, this.node, "test");
        tracker.onSuccess(this.request, 123456L, this.profile, this.node, "test");
        ((RequestTracker)Mockito.verify((Object)this.child1)).onSuccess(this.request, 123456L, this.profile, this.node, "test");
        ((RequestTracker)Mockito.verify((Object)this.child2)).onSuccess(this.request, 123456L, this.profile, this.node, "test");
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"[test] Unexpected error while notifying request tracker child1 of an onSuccess event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onError() {
        MultiplexingRequestTracker tracker = new MultiplexingRequestTracker(new RequestTracker[]{this.child1, this.child2});
        ((RequestTracker)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onError(this.request, (Throwable)this.error, 123456L, this.profile, this.node, "test");
        tracker.onError(this.request, (Throwable)this.error, 123456L, this.profile, this.node, "test");
        ((RequestTracker)Mockito.verify((Object)this.child1)).onError(this.request, (Throwable)this.error, 123456L, this.profile, this.node, "test");
        ((RequestTracker)Mockito.verify((Object)this.child2)).onError(this.request, (Throwable)this.error, 123456L, this.profile, this.node, "test");
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"[test] Unexpected error while notifying request tracker child1 of an onError event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onNodeSuccess() {
        MultiplexingRequestTracker tracker = new MultiplexingRequestTracker(new RequestTracker[]{this.child1, this.child2});
        ((RequestTracker)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onNodeSuccess(this.request, 123456L, this.profile, this.node, "test");
        tracker.onNodeSuccess(this.request, 123456L, this.profile, this.node, "test");
        ((RequestTracker)Mockito.verify((Object)this.child1)).onNodeSuccess(this.request, 123456L, this.profile, this.node, "test");
        ((RequestTracker)Mockito.verify((Object)this.child2)).onNodeSuccess(this.request, 123456L, this.profile, this.node, "test");
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"[test] Unexpected error while notifying request tracker child1 of an onNodeSuccess event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onNodeError() {
        MultiplexingRequestTracker tracker = new MultiplexingRequestTracker(new RequestTracker[]{this.child1, this.child2});
        ((RequestTracker)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onNodeError(this.request, (Throwable)this.error, 123456L, this.profile, this.node, "test");
        tracker.onNodeError(this.request, (Throwable)this.error, 123456L, this.profile, this.node, "test");
        ((RequestTracker)Mockito.verify((Object)this.child1)).onNodeError(this.request, (Throwable)this.error, 123456L, this.profile, this.node, "test");
        ((RequestTracker)Mockito.verify((Object)this.child2)).onNodeError(this.request, (Throwable)this.error, 123456L, this.profile, this.node, "test");
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"[test] Unexpected error while notifying request tracker child1 of an onNodeError event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onSessionReady() {
        MultiplexingRequestTracker tracker = new MultiplexingRequestTracker(new RequestTracker[]{this.child1, this.child2});
        ((RequestTracker)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onSessionReady(this.session);
        BDDMockito.given((Object)this.session.getName()).willReturn((Object)"test");
        tracker.onSessionReady(this.session);
        ((RequestTracker)Mockito.verify((Object)this.child1)).onSessionReady(this.session);
        ((RequestTracker)Mockito.verify((Object)this.child2)).onSessionReady(this.session);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"[test] Unexpected error while notifying request tracker child1 of an onSessionReady event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_close() throws Exception {
        MultiplexingRequestTracker tracker = new MultiplexingRequestTracker(new RequestTracker[]{this.child1, this.child2});
        NullPointerException child1Error = new NullPointerException();
        ((RequestTracker)BDDMockito.willThrow((Throwable[])new Throwable[]{child1Error}).given((Object)this.child1)).close();
        tracker.close();
        ((RequestTracker)Mockito.verify((Object)this.child1)).close();
        ((RequestTracker)Mockito.verify((Object)this.child2)).close();
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while closing request tracker child1. (NullPointerException: null)"});
    }
}

