/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.time;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.internal.core.time.AtomicTimestampGenerator;
import com.datastax.oss.driver.internal.core.time.Clock;
import com.datastax.oss.driver.internal.core.time.MonotonicTimestampGenerator;
import com.datastax.oss.driver.internal.core.time.MonotonicTimestampGeneratorTestBase;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;

public class AtomicTimestampGeneratorTest
extends MonotonicTimestampGeneratorTestBase {
    @Override
    protected MonotonicTimestampGenerator newInstance(Clock clock) {
        return new AtomicTimestampGenerator(clock, this.context);
    }

    @Test
    public void should_share_timestamps_across_all_threads() throws Exception {
        OngoingStubbing stub = Mockito.when((Object)this.clock.currentTimeMicros());
        for (int i = 0; i < 1000; ++i) {
            stub = stub.thenReturn((Object)1L);
        }
        MonotonicTimestampGenerator generator = this.newInstance(this.clock);
        int testThreadsCount = 2;
        Assertions.assertThat((int)0).isZero();
        ConcurrentSkipListSet allTimestamps = new ConcurrentSkipListSet();
        ExecutorService executor = Executors.newFixedThreadPool(2);
        for (int i = 0; i < 2; ++i) {
            executor.submit(() -> {
                for (int j = 0; j < 500; ++j) {
                    allTimestamps.add(generator.next());
                }
            });
        }
        executor.shutdown();
        if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Expected executor to shut down cleanly");
        }
        Assertions.assertThat(allTimestamps).hasSize(1000);
        Assertions.assertThat((Long)((Long)allTimestamps.first())).isEqualTo(1L);
        Assertions.assertThat((Long)((Long)allTimestamps.last())).isEqualTo(1000L);
    }
}

