/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.session;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.session.PoolManager;
import io.netty.channel.DefaultEventLoopGroup;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class PoolManagerTest {
    @Mock
    private InternalDriverContext context;
    @Mock
    private NettyOptions nettyOptions;
    @Mock
    private DriverConfig config;
    @Mock
    private DriverExecutionProfile defaultProfile;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        DefaultEventLoopGroup adminEventLoopGroup = new DefaultEventLoopGroup(1);
        Mockito.when((Object)this.nettyOptions.adminEventExecutorGroup()).thenReturn((Object)adminEventLoopGroup);
        Mockito.when((Object)this.context.getNettyOptions()).thenReturn((Object)this.nettyOptions);
        Mockito.when((Object)this.context.getEventBus()).thenReturn((Object)new EventBus("test"));
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
    }

    @Test
    public void should_use_weak_values_if_config_is_true_or_undefined() {
        Mockito.when((Object)this.defaultProfile.getBoolean((DriverOption)DefaultDriverOption.PREPARED_CACHE_WEAK_VALUES, true)).thenReturn((Object)true);
        Assertions.assertThat((Map)new PoolManager(this.context).getRepreparePayloads()).isNotInstanceOf(ConcurrentHashMap.class);
    }

    @Test
    public void should_not_use_weak_values_if_config_is_false() {
        Mockito.when((Object)this.defaultProfile.getBoolean((DriverOption)DefaultDriverOption.PREPARED_CACHE_WEAK_VALUES, true)).thenReturn((Object)false);
        Assertions.assertThat((Map)new PoolManager(this.context).getRepreparePayloads()).isInstanceOf(ConcurrentHashMap.class);
    }
}

