/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.session;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.core.pool.ChannelPoolFactory;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.collect.ListMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.MultimapBuilder;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import org.mockito.stubbing.OngoingStubbing;

public class MockChannelPoolFactoryHelper {
    private final ChannelPoolFactory channelPoolFactory;
    private final InOrder inOrder;
    private final Map<Params, Integer> previous = new HashMap<Params, Integer>();

    public static Builder builder(ChannelPoolFactory channelPoolFactory) {
        return new Builder(channelPoolFactory);
    }

    private MockChannelPoolFactoryHelper(ChannelPoolFactory channelPoolFactory) {
        this.channelPoolFactory = channelPoolFactory;
        this.inOrder = Mockito.inOrder((Object[])new Object[]{channelPoolFactory});
    }

    public void waitForCall(Node node, CqlIdentifier keyspace, NodeDistance distance) {
        this.waitForCalls(node, keyspace, distance, 1);
    }

    public void waitForCalls(Node node, CqlIdentifier keyspace, NodeDistance distance, int expected) {
        Params params = new Params(node, keyspace, distance);
        int fromLastTime = this.previous.getOrDefault(params, 0);
        if (fromLastTime >= expected) {
            this.previous.put(params, fromLastTime - expected);
            return;
        }
        ArgumentCaptor contextCaptor = ArgumentCaptor.forClass(InternalDriverContext.class);
        ((ChannelPoolFactory)this.inOrder.verify((Object)this.channelPoolFactory, Mockito.timeout((long)500L).atLeast(expected -= fromLastTime))).init((Node)ArgumentMatchers.eq((Object)node), (CqlIdentifier)ArgumentMatchers.eq((Object)keyspace), (NodeDistance)ArgumentMatchers.eq((Object)distance), (InternalDriverContext)contextCaptor.capture(), (String)ArgumentMatchers.eq((Object)"test"));
        int actual = contextCaptor.getAllValues().size();
        int extras = actual - expected;
        if (extras > 0) {
            this.previous.compute(params, (k, v) -> v == null ? extras : v + extras);
        }
    }

    public void verifyNoMoreCalls() {
        ((ChannelPoolFactory)this.inOrder.verify((Object)this.channelPoolFactory, Mockito.timeout((long)500L).times(0))).init((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class), (NodeDistance)ArgumentMatchers.any(NodeDistance.class), (InternalDriverContext)ArgumentMatchers.any(InternalDriverContext.class), (String)ArgumentMatchers.any(String.class));
        HashSet counts = Sets.newHashSet(this.previous.values());
        if (!counts.isEmpty()) {
            Assertions.assertThat((Iterable)counts).containsExactly((Object[])new Integer[]{0});
        }
    }

    private static class Params {
        private final Node node;
        private final CqlIdentifier keyspace;
        private final NodeDistance distance;

        private Params(Node node, CqlIdentifier keyspace, NodeDistance distance) {
            this.node = node;
            this.keyspace = keyspace;
            this.distance = distance;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof Params) {
                Params that = (Params)other;
                return Objects.equals(this.node, that.node) && Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.distance, that.distance);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.node, this.keyspace, this.distance);
        }
    }

    public static class Builder {
        private final ChannelPoolFactory channelPoolFactory;
        private final ListMultimap<Params, Object> invocations = MultimapBuilder.hashKeys().arrayListValues().build();

        private Builder(ChannelPoolFactory channelPoolFactory) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)MockUtil.isMock((Object)channelPoolFactory)).as("expected a mock", new Object[0])).isTrue();
            Mockito.verifyZeroInteractions((Object[])new Object[]{channelPoolFactory});
            this.channelPoolFactory = channelPoolFactory;
        }

        public Builder success(Node node, CqlIdentifier keyspaceName, NodeDistance distance, ChannelPool pool) {
            this.invocations.put((Object)new Params(node, keyspaceName, distance), (Object)pool);
            return this;
        }

        public Builder failure(Node node, CqlIdentifier keyspaceName, NodeDistance distance, String error) {
            this.invocations.put((Object)new Params(node, keyspaceName, distance), (Object)new Exception(error));
            return this;
        }

        public Builder failure(Node node, CqlIdentifier keyspaceName, NodeDistance distance, Throwable error) {
            this.invocations.put((Object)new Params(node, keyspaceName, distance), (Object)error);
            return this;
        }

        public Builder pending(Node node, CqlIdentifier keyspaceName, NodeDistance distance, CompletionStage<ChannelPool> future) {
            this.invocations.put((Object)new Params(node, keyspaceName, distance), future);
            return this;
        }

        public MockChannelPoolFactoryHelper build() {
            this.stub();
            return new MockChannelPoolFactoryHelper(this.channelPoolFactory);
        }

        private void stub() {
            for (Params params : this.invocations.keySet()) {
                ArrayDeque<CompletionStage> results = new ArrayDeque<CompletionStage>();
                for (Object object : this.invocations.get((Object)params)) {
                    if (object instanceof ChannelPool) {
                        results.add(CompletableFuture.completedFuture((ChannelPool)object));
                        continue;
                    }
                    if (object instanceof Throwable) {
                        results.add(CompletableFutures.failedFuture((Throwable)((Throwable)object)));
                        continue;
                    }
                    if (object instanceof CompletableFuture) {
                        CompletionStage future = (CompletionStage)object;
                        results.add(future);
                        continue;
                    }
                    Assertions.fail((String)("unexpected type: " + object.getClass()));
                }
                if (results.size() <= 0) continue;
                CompletionStage first = (CompletionStage)results.poll();
                OngoingStubbing ongoingStubbing = Mockito.when((Object)this.channelPoolFactory.init((Node)ArgumentMatchers.eq((Object)params.node), (CqlIdentifier)ArgumentMatchers.eq((Object)params.keyspace), (NodeDistance)ArgumentMatchers.eq((Object)params.distance), (InternalDriverContext)ArgumentMatchers.any(InternalDriverContext.class), (String)ArgumentMatchers.eq((Object)"test"))).thenReturn((Object)first);
                for (CompletionStage result : results) {
                    ongoingStubbing.thenReturn((Object)result);
                }
            }
        }
    }
}

