/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.TestDataProviders;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.protocol.BuiltInCompressors;
import com.datastax.oss.driver.internal.core.protocol.Lz4Compressor;
import com.datastax.oss.driver.internal.core.protocol.SnappyCompressor;
import com.datastax.oss.protocol.internal.NoopCompressor;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Locale;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@RunWith(value=DataProviderRunner.class)
public class BuiltInCompressorsTest {
    @Mock
    private DriverContext context;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    @UseDataProvider(location={TestDataProviders.class}, value="locales")
    public void should_create_instance_for_supported_algorithms(Locale locale) {
        Locale def = Locale.getDefault();
        try {
            Locale.setDefault(locale);
            Assertions.assertThat((Object)BuiltInCompressors.newInstance((String)"lz4", (DriverContext)this.context)).isInstanceOf(Lz4Compressor.class);
            Assertions.assertThat((Object)BuiltInCompressors.newInstance((String)"snappy", (DriverContext)this.context)).isInstanceOf(SnappyCompressor.class);
            Assertions.assertThat((Object)BuiltInCompressors.newInstance((String)"none", (DriverContext)this.context)).isInstanceOf(NoopCompressor.class);
            Assertions.assertThat((Object)BuiltInCompressors.newInstance((String)"LZ4", (DriverContext)this.context)).isInstanceOf(Lz4Compressor.class);
            Assertions.assertThat((Object)BuiltInCompressors.newInstance((String)"SNAPPY", (DriverContext)this.context)).isInstanceOf(SnappyCompressor.class);
            Assertions.assertThat((Object)BuiltInCompressors.newInstance((String)"NONE", (DriverContext)this.context)).isInstanceOf(NoopCompressor.class);
        }
        finally {
            Locale.setDefault(def);
        }
    }

    @Test
    public void should_throw_when_unsupported_algorithm() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BuiltInCompressors.newInstance((String)"GZIP", (DriverContext)this.context)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Unsupported compression algorithm 'GZIP'");
    }
}

