/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.pool;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.channel.ChannelEvent;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.MockChannelFactoryHelper;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.core.pool.ChannelPoolTestBase;
import io.netty.channel.ChannelPromise;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ChannelPoolShutdownTest
extends ChannelPoolTestBase {
    @Test
    public void should_close_all_channels_when_closed() throws Exception {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)3);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        DriverChannel channel3 = this.newMockDriverChannel(3);
        DriverChannel channel4 = this.newMockDriverChannel(4);
        CompletableFuture<DriverChannel> channel4Future = new CompletableFuture<DriverChannel>();
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node, channel1).success((Node)this.node, channel2).success((Node)this.node, channel3).pending((Node)this.node, channel4Future).build();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventBus});
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 3);
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(3))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        ((ChannelPromise)channel3.closeStartedFuture()).setSuccess();
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(1))).fire((Object)ChannelEvent.channelClosed((Node)this.node));
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)VERIFY_TIMEOUT)).nextDelay();
        factoryHelper.waitForCalls((Node)this.node, 1);
        CompletionStage closeFuture = pool.closeAsync();
        ((DriverChannel)Mockito.verify((Object)channel1, (VerificationMode)VERIFY_TIMEOUT)).close();
        ((DriverChannel)Mockito.verify((Object)channel2, (VerificationMode)VERIFY_TIMEOUT)).close();
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(2))).fire((Object)ChannelEvent.channelClosed((Node)this.node));
        ((DriverChannel)Mockito.verify((Object)channel3, (VerificationMode)Mockito.never())).close();
        channel4Future.complete(channel4);
        ((DriverChannel)Mockito.verify((Object)channel4, (VerificationMode)VERIFY_TIMEOUT)).forceClose();
        ((EventBus)inOrder.verify((Object)this.eventBus, Mockito.never())).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((EventBus)inOrder.verify((Object)this.eventBus, Mockito.never())).fire((Object)ChannelEvent.channelClosed((Node)this.node));
        ((ChannelPromise)channel1.closeFuture()).setSuccess();
        ((ChannelPromise)channel2.closeFuture()).setSuccess();
        ((ChannelPromise)channel3.closeFuture()).setSuccess();
        Assertions.assertThatStage(closeFuture).isSuccess();
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_force_close_all_channels_when_force_closed() throws Exception {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)3);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        DriverChannel channel3 = this.newMockDriverChannel(3);
        DriverChannel channel4 = this.newMockDriverChannel(4);
        CompletableFuture<DriverChannel> channel4Future = new CompletableFuture<DriverChannel>();
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node, channel1).success((Node)this.node, channel2).success((Node)this.node, channel3).pending((Node)this.node, channel4Future).build();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventBus});
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 3);
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(3))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((ChannelPromise)channel3.closeStartedFuture()).setSuccess();
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(1))).fire((Object)ChannelEvent.channelClosed((Node)this.node));
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)VERIFY_TIMEOUT)).nextDelay();
        factoryHelper.waitForCalls((Node)this.node, 1);
        CompletionStage closeFuture = pool.forceCloseAsync();
        ((DriverChannel)Mockito.verify((Object)channel1, (VerificationMode)VERIFY_TIMEOUT)).forceClose();
        ((DriverChannel)Mockito.verify((Object)channel2, (VerificationMode)VERIFY_TIMEOUT)).forceClose();
        ((DriverChannel)Mockito.verify((Object)channel3, (VerificationMode)VERIFY_TIMEOUT)).forceClose();
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(2))).fire((Object)ChannelEvent.channelClosed((Node)this.node));
        channel4Future.complete(channel4);
        ((DriverChannel)Mockito.verify((Object)channel4, (VerificationMode)VERIFY_TIMEOUT)).forceClose();
        ((EventBus)inOrder.verify((Object)this.eventBus, Mockito.never())).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((EventBus)inOrder.verify((Object)this.eventBus, Mockito.never())).fire((Object)ChannelEvent.channelClosed((Node)this.node));
        ((ChannelPromise)channel1.closeFuture()).setSuccess();
        ((ChannelPromise)channel2.closeFuture()).setSuccess();
        ((ChannelPromise)channel3.closeFuture()).setSuccess();
        Assertions.assertThatStage(closeFuture).isSuccess();
        factoryHelper.verifyNoMoreCalls();
    }
}

