/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.pool;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.channel.ChannelEvent;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.MockChannelFactoryHelper;
import com.datastax.oss.driver.internal.core.config.ConfigChangeEvent;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.core.pool.ChannelPoolTestBase;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ChannelPoolResizeTest
extends ChannelPoolTestBase {
    @Test
    public void should_shrink_outside_of_reconnection() throws Exception {
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE)).thenReturn((Object)4);
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)2);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        DriverChannel channel3 = this.newMockDriverChannel(3);
        DriverChannel channel4 = this.newMockDriverChannel(4);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node, channel1).success((Node)this.node, channel2).success((Node)this.node, channel3).success((Node)this.node, channel4).build();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventBus});
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.REMOTE, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 4);
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel1, channel2, channel3, channel4});
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(4))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        pool.resize(NodeDistance.LOCAL);
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(2))).fire((Object)ChannelEvent.channelClosed((Node)this.node));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel3, channel4}));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_shrink_during_reconnection() throws Exception {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE)).thenReturn((Object)4);
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)2);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        DriverChannel channel3 = this.newMockDriverChannel(3);
        CompletableFuture<DriverChannel> channel3Future = new CompletableFuture<DriverChannel>();
        DriverChannel channel4 = this.newMockDriverChannel(4);
        CompletableFuture<DriverChannel> channel4Future = new CompletableFuture<DriverChannel>();
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node, channel1).success((Node)this.node, channel2).failure((Node)this.node, "mock channel init failure").failure((Node)this.node, "mock channel init failure").pending((Node)this.node, channel3Future).pending((Node)this.node, channel4Future).build();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventBus});
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.REMOTE, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 4);
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(2))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel1, channel2});
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule)).nextDelay();
        ((EventBus)inOrder.verify((Object)this.eventBus)).fire((Object)ChannelEvent.reconnectionStarted((Node)this.node));
        pool.resize(NodeDistance.LOCAL);
        TimeUnit.MILLISECONDS.sleep(200L);
        channel3Future.complete(channel3);
        channel4Future.complete(channel4);
        factoryHelper.waitForCalls((Node)this.node, 2);
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStopped((Node)this.node));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel1, channel2}));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_grow_outside_of_reconnection() throws Exception {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)2);
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE)).thenReturn((Object)4);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        DriverChannel channel3 = this.newMockDriverChannel(3);
        DriverChannel channel4 = this.newMockDriverChannel(4);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node, channel1).success((Node)this.node, channel2).success((Node)this.node, channel3).success((Node)this.node, channel4).build();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventBus});
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 2);
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(2))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel1, channel2});
        pool.resize(NodeDistance.REMOTE);
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)VERIFY_TIMEOUT)).nextDelay();
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStarted((Node)this.node));
        factoryHelper.waitForCalls((Node)this.node, 2);
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(2))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStopped((Node)this.node));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel1, channel2, channel3, channel4}));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_grow_during_reconnection() throws Exception {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)2);
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE)).thenReturn((Object)4);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        CompletableFuture<DriverChannel> channel2Future = new CompletableFuture<DriverChannel>();
        DriverChannel channel3 = this.newMockDriverChannel(3);
        CompletableFuture<DriverChannel> channel3Future = new CompletableFuture<DriverChannel>();
        DriverChannel channel4 = this.newMockDriverChannel(4);
        CompletableFuture<DriverChannel> channel4Future = new CompletableFuture<DriverChannel>();
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node, channel1).failure((Node)this.node, "mock channel init failure").pending((Node)this.node, channel2Future).pending((Node)this.node, channel3Future).pending((Node)this.node, channel4Future).build();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventBus});
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 2);
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel1});
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)VERIFY_TIMEOUT)).nextDelay();
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStarted((Node)this.node));
        pool.resize(NodeDistance.REMOTE);
        TimeUnit.MILLISECONDS.sleep(200L);
        channel2Future.complete(channel2);
        factoryHelper.waitForCall((Node)this.node);
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel1, channel2}));
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)VERIFY_TIMEOUT.times(2))).nextDelay();
        ((EventBus)inOrder.verify((Object)this.eventBus, Mockito.never())).fire((Object)ChannelEvent.reconnectionStopped((Node)this.node));
        ((EventBus)inOrder.verify((Object)this.eventBus, Mockito.never())).fire((Object)ChannelEvent.reconnectionStarted((Node)this.node));
        factoryHelper.waitForCalls((Node)this.node, 2);
        channel3Future.complete(channel3);
        channel4Future.complete(channel4);
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(2))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStopped((Node)this.node));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel1, channel2, channel3, channel4}));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_resize_outside_of_reconnection_if_config_changes() throws Exception {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)2);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        DriverChannel channel3 = this.newMockDriverChannel(3);
        DriverChannel channel4 = this.newMockDriverChannel(4);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node, channel1).success((Node)this.node, channel2).success((Node)this.node, channel3).success((Node)this.node, channel4).build();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventBus});
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 2);
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(2))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel1, channel2});
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)4);
        this.eventBus.fire((Object)ConfigChangeEvent.INSTANCE);
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)VERIFY_TIMEOUT)).nextDelay();
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStarted((Node)this.node));
        factoryHelper.waitForCalls((Node)this.node, 2);
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(2))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStopped((Node)this.node));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel1, channel2, channel3, channel4}));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_resize_during_reconnection_if_config_changes() throws Exception {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)2);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        CompletableFuture<DriverChannel> channel2Future = new CompletableFuture<DriverChannel>();
        DriverChannel channel3 = this.newMockDriverChannel(3);
        CompletableFuture<DriverChannel> channel3Future = new CompletableFuture<DriverChannel>();
        DriverChannel channel4 = this.newMockDriverChannel(4);
        CompletableFuture<DriverChannel> channel4Future = new CompletableFuture<DriverChannel>();
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node, channel1).failure((Node)this.node, "mock channel init failure").pending((Node)this.node, channel2Future).pending((Node)this.node, channel3Future).pending((Node)this.node, channel4Future).build();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventBus});
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 2);
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel1});
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)VERIFY_TIMEOUT)).nextDelay();
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStarted((Node)this.node));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)4);
        this.eventBus.fire((Object)ConfigChangeEvent.INSTANCE);
        TimeUnit.MILLISECONDS.sleep(200L);
        channel2Future.complete(channel2);
        factoryHelper.waitForCall((Node)this.node);
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel1, channel2}));
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)VERIFY_TIMEOUT.times(2))).nextDelay();
        ((EventBus)inOrder.verify((Object)this.eventBus, Mockito.never())).fire((Object)ChannelEvent.reconnectionStopped((Node)this.node));
        ((EventBus)inOrder.verify((Object)this.eventBus, Mockito.never())).fire((Object)ChannelEvent.reconnectionStarted((Node)this.node));
        factoryHelper.waitForCalls((Node)this.node, 2);
        channel3Future.complete(channel3);
        channel4Future.complete(channel4);
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(2))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        ((EventBus)inOrder.verify((Object)this.eventBus, (VerificationMode)VERIFY_TIMEOUT)).fire((Object)ChannelEvent.reconnectionStopped((Node)this.node));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel1, channel2, channel3, channel4}));
        factoryHelper.verifyNoMoreCalls();
    }

    @Test
    public void should_ignore_config_change_if_not_relevant() throws Exception {
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofNanos(1L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).thenReturn((Object)2);
        DriverChannel channel1 = this.newMockDriverChannel(1);
        DriverChannel channel2 = this.newMockDriverChannel(2);
        MockChannelFactoryHelper factoryHelper = MockChannelFactoryHelper.builder(this.channelFactory).success((Node)this.node, channel1).success((Node)this.node, channel2).build();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.eventBus});
        CompletionStage poolFuture = ChannelPool.init((Node)this.node, null, (NodeDistance)NodeDistance.LOCAL, (InternalDriverContext)this.context, (String)"test");
        factoryHelper.waitForCalls((Node)this.node, 2);
        ((EventBus)inOrder.verify((Object)this.eventBus, VERIFY_TIMEOUT.times(2))).fire((Object)ChannelEvent.channelOpened((Node)this.node));
        Assertions.assertThatStage(poolFuture).isSuccess();
        ChannelPool pool = (ChannelPool)poolFuture.toCompletableFuture().get();
        Assertions.assertThat((Iterable)pool.channels[0]).containsOnly((Object[])new DriverChannel[]{channel1, channel2});
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE)).thenReturn((Object)1);
        this.eventBus.fire((Object)ConfigChangeEvent.INSTANCE);
        TimeUnit.MILLISECONDS.sleep(200L);
        ((ReconnectionPolicy.ReconnectionSchedule)Mockito.verify((Object)this.reconnectionSchedule, (VerificationMode)Mockito.never())).nextDelay();
        factoryHelper.verifyNoMoreCalls();
    }
}

