/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.codahale.metrics.MetricRegistry;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.DropwizardMetricsFactory;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class DropwizardMetricsFactoryTest {
    @Test
    public void should_throw_if_registry_of_wrong_type() {
        InternalDriverContext context = (InternalDriverContext)Mockito.mock(InternalDriverContext.class);
        DriverExecutionProfile profile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        DriverConfig config = (DriverConfig)Mockito.mock(DriverConfig.class);
        List<String> enabledMetrics = Collections.singletonList(DefaultSessionMetric.CQL_REQUESTS.getPath());
        Mockito.when((Object)config.getDefaultProfile()).thenReturn((Object)profile);
        Mockito.when((Object)context.getConfig()).thenReturn((Object)config);
        Mockito.when((Object)context.getSessionName()).thenReturn((Object)"MockSession");
        Mockito.when((Object)context.getMetricRegistry()).thenReturn((Object)Integer.MAX_VALUE);
        Mockito.when((Object)profile.getDuration((DriverOption)DefaultDriverOption.METRICS_NODE_EXPIRE_AFTER)).thenReturn((Object)Duration.ofHours(1L));
        Mockito.when((Object)profile.getStringList((DriverOption)DefaultDriverOption.METRICS_SESSION_ENABLED)).thenReturn(enabledMetrics);
        try {
            new DropwizardMetricsFactory((DriverContext)context);
            Assertions.fail((String)("MetricsFactory should require correct registry object type: " + MetricRegistry.class.getName()));
        }
        catch (IllegalArgumentException iae) {
            Assertions.assertThat((String)iae.getMessage()).isEqualTo("Unexpected Metrics registry object. Expected registry object to be of type '%s', but was '%s'", new Object[]{MetricRegistry.class.getName(), Integer.class.getName()});
        }
    }
}

