/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationFactor;
import org.junit.Test;

public class ReplicationFactorTest {
    @Test
    public void should_parse_factor_from_string() {
        ReplicationFactor transFactor = ReplicationFactor.fromString((String)"3/1");
        Assertions.assertThat((int)transFactor.fullReplicas()).isEqualTo(2);
        Assertions.assertThat((boolean)transFactor.hasTransientReplicas()).isTrue();
        Assertions.assertThat((int)transFactor.transientReplicas()).isEqualTo(1);
        ReplicationFactor factor = ReplicationFactor.fromString((String)"3");
        Assertions.assertThat((int)factor.fullReplicas()).isEqualTo(3);
        Assertions.assertThat((boolean)factor.hasTransientReplicas()).isFalse();
        Assertions.assertThat((int)factor.transientReplicas()).isEqualTo(0);
    }

    @Test
    public void should_create_string_from_factor() {
        ReplicationFactor transFactor = new ReplicationFactor(3, 1);
        Assertions.assertThat((String)transFactor.toString()).isEqualTo("3/1");
        ReplicationFactor factor = new ReplicationFactor(3);
        Assertions.assertThat((String)factor.toString()).isEqualTo("3");
    }
}

