/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.RandomToken;
import com.datastax.oss.driver.internal.core.metadata.token.RandomTokenRange;
import java.math.BigInteger;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class RandomTokenRangeTest {
    private static final String MIN = "-1";
    private static final String MAX = "170141183460469231731687303715884105728";

    @Test
    public void should_split_range() {
        Assertions.assertThat((List)this.range("0", "127605887595351923798765477786913079296").splitEvenly(3)).containsExactly((Object[])new TokenRange[]{this.range("0", "42535295865117307932921825928971026432"), this.range("42535295865117307932921825928971026432", "85070591730234615865843651857942052864"), this.range("85070591730234615865843651857942052864", "127605887595351923798765477786913079296")});
    }

    @Test
    public void should_split_range_that_wraps_around_the_ring() {
        Assertions.assertThat((List)this.range("127605887595351923798765477786913079296", "85070591730234615865843651857942052864").splitEvenly(3)).containsExactly((Object[])new TokenRange[]{this.range("127605887595351923798765477786913079296", "0"), this.range("0", "42535295865117307932921825928971026432"), this.range("42535295865117307932921825928971026432", "85070591730234615865843651857942052864")});
    }

    @Test
    public void should_split_range_producing_empty_splits_near_ring_end() {
        Assertions.assertThat((List)this.range(MAX, MIN).splitEvenly(3)).containsExactly((Object[])new TokenRange[]{this.range(MAX, MAX), this.range(MAX, MAX), this.range(MAX, MIN)});
        Assertions.assertThat((List)this.range(MIN, "0").splitEvenly(3)).containsExactly((Object[])new TokenRange[]{this.range(MIN, "0"), this.range("0", "0"), this.range("0", "0")});
    }

    @Test
    public void should_split_whole_ring() {
        Assertions.assertThat((List)this.range(MIN, MIN).splitEvenly(3)).containsExactly((Object[])new TokenRange[]{this.range(MIN, "56713727820156410577229101238628035242"), this.range("56713727820156410577229101238628035242", "113427455640312821154458202477256070485"), this.range("113427455640312821154458202477256070485", MIN)});
    }

    private RandomTokenRange range(String start, String end) {
        return new RandomTokenRange(new RandomToken(new BigInteger(start)), new RandomToken(new BigInteger(end)));
    }
}

