/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.refresh;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.channel.ChannelFactory;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.schema.DefaultKeyspaceMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.events.KeyspaceChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.events.TypeChangeEvent;
import com.datastax.oss.driver.internal.core.metadata.schema.refresh.SchemaRefresh;
import com.datastax.oss.driver.internal.core.type.UserDefinedTypeBuilder;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SchemaRefreshTest {
    private static final UserDefinedType OLD_T1 = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks1"), CqlIdentifier.fromInternal((String)"t1")).withField(CqlIdentifier.fromInternal((String)"i"), DataTypes.INT).build();
    private static final UserDefinedType OLD_T2 = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks1"), CqlIdentifier.fromInternal((String)"t2")).withField(CqlIdentifier.fromInternal((String)"i"), DataTypes.INT).build();
    private static final DefaultKeyspaceMetadata OLD_KS1 = SchemaRefreshTest.newKeyspace("ks1", true, OLD_T1, OLD_T2);
    @Mock
    private InternalDriverContext context;
    @Mock
    private ChannelFactory channelFactory;
    private DefaultMetadata oldMetadata;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getChannelFactory()).thenReturn((Object)this.channelFactory);
        this.oldMetadata = DefaultMetadata.EMPTY.withSchema((Map)ImmutableMap.of((Object)OLD_KS1.getName(), (Object)OLD_KS1), false, this.context);
    }

    @Test
    public void should_detect_dropped_keyspace() {
        SchemaRefresh refresh = new SchemaRefresh(Collections.emptyMap());
        MetadataRefresh.Result result = refresh.compute(this.oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getKeyspaces()).isEmpty();
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{KeyspaceChangeEvent.dropped((KeyspaceMetadata)OLD_KS1)});
    }

    @Test
    public void should_detect_created_keyspace() {
        DefaultKeyspaceMetadata ks2 = SchemaRefreshTest.newKeyspace("ks2", true, new UserDefinedType[0]);
        SchemaRefresh refresh = new SchemaRefresh((Map)ImmutableMap.of((Object)OLD_KS1.getName(), (Object)OLD_KS1, (Object)ks2.getName(), (Object)ks2));
        MetadataRefresh.Result result = refresh.compute(this.oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getKeyspaces()).hasSize(2);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{KeyspaceChangeEvent.created((KeyspaceMetadata)ks2)});
    }

    @Test
    public void should_detect_top_level_update_in_keyspace() {
        DefaultKeyspaceMetadata newKs1 = SchemaRefreshTest.newKeyspace("ks1", false, OLD_T1, OLD_T2);
        SchemaRefresh refresh = new SchemaRefresh((Map)ImmutableMap.of((Object)OLD_KS1.getName(), (Object)newKs1));
        MetadataRefresh.Result result = refresh.compute(this.oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getKeyspaces()).hasSize(1);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{KeyspaceChangeEvent.updated((KeyspaceMetadata)OLD_KS1, (KeyspaceMetadata)newKs1)});
    }

    @Test
    public void should_detect_updated_children_in_keyspace() {
        UserDefinedType newT2 = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks1"), CqlIdentifier.fromInternal((String)"t2")).withField(CqlIdentifier.fromInternal((String)"i"), DataTypes.TEXT).build();
        UserDefinedType t3 = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks1"), CqlIdentifier.fromInternal((String)"t3")).withField(CqlIdentifier.fromInternal((String)"i"), DataTypes.INT).build();
        DefaultKeyspaceMetadata newKs1 = SchemaRefreshTest.newKeyspace("ks1", true, newT2, t3);
        SchemaRefresh refresh = new SchemaRefresh((Map)ImmutableMap.of((Object)OLD_KS1.getName(), (Object)newKs1));
        MetadataRefresh.Result result = refresh.compute(this.oldMetadata, false, this.context);
        Assertions.assertThat((Object)((KeyspaceMetadata)result.newMetadata.getKeyspaces().get(OLD_KS1.getName()))).isEqualTo((Object)newKs1);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{TypeChangeEvent.dropped((UserDefinedType)OLD_T1), TypeChangeEvent.updated((UserDefinedType)OLD_T2, (UserDefinedType)newT2), TypeChangeEvent.created((UserDefinedType)t3)});
    }

    @Test
    public void should_detect_top_level_change_and_children_changes() {
        UserDefinedType newT2 = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks1"), CqlIdentifier.fromInternal((String)"t2")).withField(CqlIdentifier.fromInternal((String)"i"), DataTypes.TEXT).build();
        UserDefinedType t3 = new UserDefinedTypeBuilder(CqlIdentifier.fromInternal((String)"ks1"), CqlIdentifier.fromInternal((String)"t3")).withField(CqlIdentifier.fromInternal((String)"i"), DataTypes.INT).build();
        DefaultKeyspaceMetadata newKs1 = SchemaRefreshTest.newKeyspace("ks1", false, newT2, t3);
        SchemaRefresh refresh = new SchemaRefresh((Map)ImmutableMap.of((Object)OLD_KS1.getName(), (Object)newKs1));
        MetadataRefresh.Result result = refresh.compute(this.oldMetadata, false, this.context);
        Assertions.assertThat((Object)((KeyspaceMetadata)result.newMetadata.getKeyspaces().get(OLD_KS1.getName()))).isEqualTo((Object)newKs1);
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{KeyspaceChangeEvent.updated((KeyspaceMetadata)OLD_KS1, (KeyspaceMetadata)newKs1), TypeChangeEvent.dropped((UserDefinedType)OLD_T1), TypeChangeEvent.updated((UserDefinedType)OLD_T2, (UserDefinedType)newT2), TypeChangeEvent.created((UserDefinedType)t3)});
    }

    private static DefaultKeyspaceMetadata newKeyspace(String name, boolean durableWrites, UserDefinedType ... userTypes) {
        ImmutableMap.Builder typesMapBuilder = ImmutableMap.builder();
        for (UserDefinedType type : userTypes) {
            typesMapBuilder.put((Object)type.getName(), (Object)type);
        }
        return new DefaultKeyspaceMetadata(CqlIdentifier.fromInternal((String)name), durableWrites, false, Collections.emptyMap(), (Map)typesMapBuilder.build(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }
}

