/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.ShallowUserDefinedType;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeCqlNameParser;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public class DataTypeCqlNameParserTest {
    private static final CqlIdentifier KEYSPACE_ID = CqlIdentifier.fromInternal((String)"ks");
    @Mock
    private InternalDriverContext context;
    private DataTypeCqlNameParser parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new DataTypeCqlNameParser();
    }

    @Test
    public void should_parse_native_types() {
        for (Map.Entry entry : DataTypeCqlNameParser.NATIVE_TYPES_BY_NAME.entrySet()) {
            String className = (String)entry.getKey();
            DataType expectedType = (DataType)entry.getValue();
            Assertions.assertThat((Object)this.parse(className)).isEqualTo((Object)expectedType);
        }
    }

    @Test
    public void should_parse_collection_types() {
        Assertions.assertThat((Object)this.parse("list<text>")).isEqualTo((Object)DataTypes.listOf((DataType)DataTypes.TEXT));
        Assertions.assertThat((Object)this.parse("frozen<list<text>>")).isEqualTo((Object)DataTypes.frozenListOf((DataType)DataTypes.TEXT));
        Assertions.assertThat((Object)this.parse("set<text>")).isEqualTo((Object)DataTypes.setOf((DataType)DataTypes.TEXT));
        Assertions.assertThat((Object)this.parse("map<text,text>")).isEqualTo((Object)DataTypes.mapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.TEXT));
        Assertions.assertThat((Object)this.parse("map<text,frozen<map<int,int>>>")).isEqualTo((Object)DataTypes.mapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.frozenMapOf((DataType)DataTypes.INT, (DataType)DataTypes.INT)));
    }

    @Test
    public void should_parse_top_level_user_type_as_shallow() {
        UserDefinedType addressType = (UserDefinedType)this.parse("address");
        Assertions.assertThat((Object)addressType).isInstanceOf(ShallowUserDefinedType.class);
        Assertions.assertThat((Object)addressType.getKeyspace()).isEqualTo((Object)KEYSPACE_ID);
        Assertions.assertThat((String)addressType.getName().asInternal()).isEqualTo("address");
        Assertions.assertThat((boolean)addressType.isFrozen()).isFalse();
        UserDefinedType frozenAddressType = (UserDefinedType)this.parse("frozen<address>");
        Assertions.assertThat((Object)frozenAddressType).isInstanceOf(ShallowUserDefinedType.class);
        Assertions.assertThat((Object)frozenAddressType.getKeyspace()).isEqualTo((Object)KEYSPACE_ID);
        Assertions.assertThat((String)frozenAddressType.getName().asInternal()).isEqualTo("address");
        Assertions.assertThat((boolean)frozenAddressType.isFrozen()).isTrue();
    }

    @Test
    public void should_reuse_existing_user_type_when_not_top_level() {
        UserDefinedType addressType = (UserDefinedType)Mockito.mock(UserDefinedType.class);
        UserDefinedType frozenAddressType = (UserDefinedType)Mockito.mock(UserDefinedType.class);
        Mockito.when((Object)addressType.copy(false)).thenReturn((Object)addressType);
        Mockito.when((Object)addressType.copy(true)).thenReturn((Object)frozenAddressType);
        ImmutableMap existingTypes = ImmutableMap.of((Object)CqlIdentifier.fromInternal((String)"address"), (Object)addressType);
        ListType listOfAddress = (ListType)this.parse("list<address>", (Map<CqlIdentifier, UserDefinedType>)existingTypes);
        Assertions.assertThat((Object)listOfAddress.getElementType()).isEqualTo((Object)addressType);
        ListType listOfFrozenAddress = (ListType)this.parse("list<frozen<address>>", (Map<CqlIdentifier, UserDefinedType>)existingTypes);
        Assertions.assertThat((Object)listOfFrozenAddress.getElementType()).isEqualTo((Object)frozenAddressType);
    }

    @Test
    public void should_parse_tuple() {
        TupleType tupleType = (TupleType)this.parse("tuple<int,text,float>");
        Assertions.assertThat((int)tupleType.getComponentTypes().size()).isEqualTo(3);
        Assertions.assertThat((Object)((DataType)tupleType.getComponentTypes().get(0))).isEqualTo((Object)DataTypes.INT);
        Assertions.assertThat((Object)((DataType)tupleType.getComponentTypes().get(1))).isEqualTo((Object)DataTypes.TEXT);
        Assertions.assertThat((Object)((DataType)tupleType.getComponentTypes().get(2))).isEqualTo((Object)DataTypes.FLOAT);
    }

    @Test
    public void should_parse_udt_named_like_collection_type() {
        Assertions.assertThat((Object)this.parse("tuple")).isInstanceOf(UserDefinedType.class);
        Assertions.assertThat((Object)this.parse("list")).isInstanceOf(UserDefinedType.class);
        Assertions.assertThat((Object)this.parse("map")).isInstanceOf(UserDefinedType.class);
        Assertions.assertThat((Object)this.parse("frozen")).isInstanceOf(UserDefinedType.class);
        MapType mapType = (MapType)this.parse("map<list,frozen>");
        Assertions.assertThat((Object)mapType.getKeyType()).isInstanceOf(UserDefinedType.class);
        Assertions.assertThat((Object)mapType.getValueType()).isInstanceOf(UserDefinedType.class);
    }

    private DataType parse(String toParse) {
        return this.parse(toParse, null);
    }

    private DataType parse(String toParse, Map<CqlIdentifier, UserDefinedType> existingTypes) {
        return this.parser.parse(KEYSPACE_ID, toParse, existingTypes, this.context);
    }
}

