/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.datastax.oss.driver.api.core.metadata.schema.AggregateMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.metadata.schema.MultiplexingSchemaChangeListener;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.BDDMockito;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.Strict.class)
public class MultiplexingSchemaChangeListenerTest {
    @Mock
    private SchemaChangeListener child1;
    @Mock
    private SchemaChangeListener child2;
    @Mock
    private Session session;
    @Mock
    private KeyspaceMetadata keyspace1;
    @Mock
    private KeyspaceMetadata keyspace2;
    @Mock
    private TableMetadata table1;
    @Mock
    private TableMetadata table2;
    @Mock
    private UserDefinedType userDefinedType1;
    @Mock
    private UserDefinedType userDefinedType2;
    @Mock
    private FunctionMetadata function1;
    @Mock
    private FunctionMetadata function2;
    @Mock
    private AggregateMetadata aggregate1;
    @Mock
    private AggregateMetadata aggregate2;
    @Mock
    private ViewMetadata view1;
    @Mock
    private ViewMetadata view2;
    @Mock
    private Appender<ILoggingEvent> appender;
    @Captor
    private ArgumentCaptor<ILoggingEvent> loggingEventCaptor;
    private Logger logger;
    private Level initialLogLevel;

    @Before
    public void addAppenders() {
        this.logger = (Logger)LoggerFactory.getLogger(MultiplexingSchemaChangeListener.class);
        this.initialLogLevel = this.logger.getLevel();
        this.logger.setLevel(Level.WARN);
        this.logger.addAppender(this.appender);
    }

    @After
    public void removeAppenders() {
        this.logger.detachAppender(this.appender);
        this.logger.setLevel(this.initialLogLevel);
    }

    @Test
    public void should_register() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener();
        listener.register(this.child1);
        listener.register(this.child2);
        ((AbstractListAssert)Assertions.assertThat((Object)listener).extracting("listeners").asList().hasSize(2)).contains(new Object[]{this.child1, this.child2});
    }

    @Test
    public void should_flatten_child_multiplexing_listener_via_constructor() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2})});
        ((AbstractListAssert)Assertions.assertThat((Object)listener).extracting("listeners").asList().hasSize(2)).contains(new Object[]{this.child1, this.child2});
    }

    @Test
    public void should_flatten_child_multiplexing_listener_via_register() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener();
        listener.register((SchemaChangeListener)new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2}));
        ((AbstractListAssert)Assertions.assertThat((Object)listener).extracting("listeners").asList().hasSize(2)).contains(new Object[]{this.child1, this.child2});
    }

    @Test
    public void should_notify_onKeyspaceCreated() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onKeyspaceCreated(this.keyspace1);
        listener.onKeyspaceCreated(this.keyspace1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onKeyspaceCreated(this.keyspace1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onKeyspaceCreated(this.keyspace1);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onKeyspaceCreated event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onKeyspaceDropped() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onKeyspaceDropped(this.keyspace1);
        listener.onKeyspaceDropped(this.keyspace1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onKeyspaceDropped(this.keyspace1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onKeyspaceDropped(this.keyspace1);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onKeyspaceDropped event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onKeyspaceUpdated() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onKeyspaceUpdated(this.keyspace1, this.keyspace2);
        listener.onKeyspaceUpdated(this.keyspace1, this.keyspace2);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onKeyspaceUpdated(this.keyspace1, this.keyspace2);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onKeyspaceUpdated(this.keyspace1, this.keyspace2);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onKeyspaceUpdated event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onTableCreated() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onTableCreated(this.table1);
        listener.onTableCreated(this.table1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onTableCreated(this.table1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onTableCreated(this.table1);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onTableCreated event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onTableDropped() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onTableDropped(this.table1);
        listener.onTableDropped(this.table1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onTableDropped(this.table1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onTableDropped(this.table1);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onTableDropped event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onTableUpdated() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onTableUpdated(this.table1, this.table2);
        listener.onTableUpdated(this.table1, this.table2);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onTableUpdated(this.table1, this.table2);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onTableUpdated(this.table1, this.table2);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onTableUpdated event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onUserDefinedTypeCreated() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onUserDefinedTypeCreated(this.userDefinedType1);
        listener.onUserDefinedTypeCreated(this.userDefinedType1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onUserDefinedTypeCreated(this.userDefinedType1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onUserDefinedTypeCreated(this.userDefinedType1);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onUserDefinedTypeCreated event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onUserDefinedTypeDropped() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onUserDefinedTypeDropped(this.userDefinedType1);
        listener.onUserDefinedTypeDropped(this.userDefinedType1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onUserDefinedTypeDropped(this.userDefinedType1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onUserDefinedTypeDropped(this.userDefinedType1);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onUserDefinedTypeDropped event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onUserDefinedTypeUpdated() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onUserDefinedTypeUpdated(this.userDefinedType1, this.userDefinedType2);
        listener.onUserDefinedTypeUpdated(this.userDefinedType1, this.userDefinedType2);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onUserDefinedTypeUpdated(this.userDefinedType1, this.userDefinedType2);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onUserDefinedTypeUpdated(this.userDefinedType1, this.userDefinedType2);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onUserDefinedTypeUpdated event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onFunctionCreated() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onFunctionCreated(this.function1);
        listener.onFunctionCreated(this.function1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onFunctionCreated(this.function1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onFunctionCreated(this.function1);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onFunctionCreated event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onFunctionDropped() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onFunctionDropped(this.function1);
        listener.onFunctionDropped(this.function1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onFunctionDropped(this.function1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onFunctionDropped(this.function1);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onFunctionDropped event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onFunctionUpdated() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onFunctionUpdated(this.function1, this.function2);
        listener.onFunctionUpdated(this.function1, this.function2);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onFunctionUpdated(this.function1, this.function2);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onFunctionUpdated(this.function1, this.function2);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onFunctionUpdated event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onAggregateCreated() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onAggregateCreated(this.aggregate1);
        listener.onAggregateCreated(this.aggregate1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onAggregateCreated(this.aggregate1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onAggregateCreated(this.aggregate1);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onAggregateCreated event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onAggregateDropped() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onAggregateDropped(this.aggregate1);
        listener.onAggregateDropped(this.aggregate1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onAggregateDropped(this.aggregate1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onAggregateDropped(this.aggregate1);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onAggregateDropped event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onAggregateUpdated() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onAggregateUpdated(this.aggregate1, this.aggregate2);
        listener.onAggregateUpdated(this.aggregate1, this.aggregate2);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onAggregateUpdated(this.aggregate1, this.aggregate2);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onAggregateUpdated(this.aggregate1, this.aggregate2);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onAggregateUpdated event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onViewCreated() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onViewCreated(this.view1);
        listener.onViewCreated(this.view1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onViewCreated(this.view1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onViewCreated(this.view1);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onViewCreated event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onViewDropped() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onViewDropped(this.view1);
        listener.onViewDropped(this.view1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onViewDropped(this.view1);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onViewDropped(this.view1);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onViewDropped event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onViewUpdated() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onViewUpdated(this.view1, this.view2);
        listener.onViewUpdated(this.view1, this.view2);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onViewUpdated(this.view1, this.view2);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onViewUpdated(this.view1, this.view2);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onViewUpdated event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onSessionReady() {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onSessionReady(this.session);
        listener.onSessionReady(this.session);
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).onSessionReady(this.session);
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).onSessionReady(this.session);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying schema change listener child1 of an onSessionReady event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_close() throws Exception {
        MultiplexingSchemaChangeListener listener = new MultiplexingSchemaChangeListener(new SchemaChangeListener[]{this.child1, this.child2});
        NullPointerException child1Error = new NullPointerException();
        ((SchemaChangeListener)BDDMockito.willThrow((Throwable[])new Throwable[]{child1Error}).given((Object)this.child1)).close();
        listener.close();
        ((SchemaChangeListener)Mockito.verify((Object)this.child1)).close();
        ((SchemaChangeListener)Mockito.verify((Object)this.child2)).close();
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while closing schema change listener child1. (NullPointerException: null)"});
    }
}

