/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import java.net.InetSocketAddress;
import java.util.UUID;

public class TestNodeFactory {
    public static DefaultNode newNode(int lastIpByte, InternalDriverContext context) {
        DefaultNode node = TestNodeFactory.newContactPoint(lastIpByte, context);
        node.hostId = UUID.randomUUID();
        node.broadcastRpcAddress = (InetSocketAddress)node.getEndPoint().resolve();
        return node;
    }

    public static DefaultNode newNode(int lastIpByte, UUID hostId, InternalDriverContext context) {
        DefaultNode node = TestNodeFactory.newContactPoint(lastIpByte, context);
        node.hostId = hostId;
        node.broadcastRpcAddress = (InetSocketAddress)node.getEndPoint().resolve();
        return node;
    }

    public static DefaultNode newContactPoint(int lastIpByte, InternalDriverContext context) {
        DefaultEndPoint endPoint = TestNodeFactory.newEndPoint(lastIpByte);
        return new DefaultNode((EndPoint)endPoint, context);
    }

    public static DefaultEndPoint newEndPoint(int lastByteOfIp) {
        return new DefaultEndPoint(new InetSocketAddress("127.0.0." + lastByteOfIp, 9042));
    }
}

