/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.internal.core.adminrequest.AdminResult;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.metadata.SchemaAgreementChecker;
import com.datastax.oss.driver.internal.core.metadata.TestNodeFactory;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterators;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import io.netty.channel.EventLoop;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=DataProviderRunner.class)
public class SchemaAgreementCheckerTest {
    private static final UUID VERSION1 = UUID.randomUUID();
    private static final UUID VERSION2 = UUID.randomUUID();
    private static final UUID NODE_2_HOST_ID = UUID.randomUUID();
    @Mock
    private InternalDriverContext context;
    @Mock
    private DriverConfig config;
    @Mock
    private DriverExecutionProfile defaultConfig;
    @Mock
    private DriverChannel channel;
    @Mock
    private EventLoop eventLoop;
    @Mock
    private MetadataManager metadataManager;
    @Mock
    private MetricsFactory metricsFactory;
    @Mock
    private Metadata metadata;
    @Mock
    private DefaultNode node1;
    @Mock
    private DefaultNode node2;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.context.getMetricsFactory()).thenReturn((Object)this.metricsFactory);
        this.node1 = TestNodeFactory.newNode(1, this.context);
        this.node2 = TestNodeFactory.newNode(2, NODE_2_HOST_ID, this.context);
        Mockito.when((Object)this.defaultConfig.getDuration((DriverOption)DefaultDriverOption.CONTROL_CONNECTION_TIMEOUT)).thenReturn((Object)Duration.ofSeconds(1L));
        Mockito.when((Object)this.defaultConfig.getDuration((DriverOption)DefaultDriverOption.CONTROL_CONNECTION_AGREEMENT_INTERVAL)).thenReturn((Object)Duration.ofMillis(200L));
        Mockito.when((Object)this.defaultConfig.getDuration((DriverOption)DefaultDriverOption.CONTROL_CONNECTION_AGREEMENT_TIMEOUT)).thenReturn((Object)Duration.ofSeconds(10L));
        Mockito.when((Object)this.defaultConfig.getBoolean((DriverOption)DefaultDriverOption.CONTROL_CONNECTION_AGREEMENT_WARN)).thenReturn((Object)true);
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultConfig);
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        ImmutableMap nodes = ImmutableMap.of((Object)Objects.requireNonNull(this.node1.getHostId()), (Object)this.node1, (Object)Objects.requireNonNull(this.node2.getHostId()), (Object)this.node2);
        Mockito.when((Object)this.metadata.getNodes()).thenReturn((Object)nodes);
        Mockito.when((Object)this.metadataManager.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.context.getMetadataManager()).thenReturn((Object)this.metadataManager);
        this.node2.state = NodeState.UP;
        Mockito.when((Object)this.eventLoop.schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenAnswer(invocation -> {
            Runnable task = (Runnable)invocation.getArgument(0);
            task.run();
            return null;
        });
        Mockito.when((Object)this.channel.eventLoop()).thenReturn((Object)this.eventLoop);
    }

    @Test
    public void should_skip_if_timeout_is_zero() {
        Mockito.when((Object)this.defaultConfig.getDuration((DriverOption)DefaultDriverOption.CONTROL_CONNECTION_AGREEMENT_TIMEOUT)).thenReturn((Object)Duration.ZERO);
        TestSchemaAgreementChecker checker = new TestSchemaAgreementChecker(this.channel, this.context);
        CompletionStage future = checker.run();
        Assertions.assertThatStage(future).isSuccess(b -> Assertions.assertThat((Boolean)b).isFalse());
    }

    @Test
    public void should_succeed_if_only_one_node() {
        TestSchemaAgreementChecker checker = new TestSchemaAgreementChecker(this.channel, this.context);
        checker.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT schema_version FROM system.local WHERE key='local'", this.mockResult(this.mockLocalRow(SchemaAgreementCheckerTest.VERSION1))), new StubbedQuery("SELECT * FROM system.peers", this.mockResult(new AdminRow[0]))});
        CompletionStage future = checker.run();
        Assertions.assertThatStage(future).isSuccess(b -> Assertions.assertThat((Boolean)b).isTrue());
    }

    @Test
    public void should_succeed_if_versions_match_on_first_try() {
        TestSchemaAgreementChecker checker = new TestSchemaAgreementChecker(this.channel, this.context);
        checker.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT schema_version FROM system.local WHERE key='local'", this.mockResult(this.mockLocalRow(SchemaAgreementCheckerTest.VERSION1))), new StubbedQuery("SELECT * FROM system.peers", this.mockResult(this.mockValidPeerRow(SchemaAgreementCheckerTest.VERSION1)))});
        CompletionStage future = checker.run();
        Assertions.assertThatStage(future).isSuccess(b -> Assertions.assertThat((Boolean)b).isTrue());
    }

    @Test
    public void should_ignore_down_peers() {
        TestSchemaAgreementChecker checker = new TestSchemaAgreementChecker(this.channel, this.context);
        this.node2.state = NodeState.DOWN;
        checker.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT schema_version FROM system.local WHERE key='local'", this.mockResult(this.mockLocalRow(SchemaAgreementCheckerTest.VERSION1))), new StubbedQuery("SELECT * FROM system.peers", this.mockResult(this.mockValidPeerRow(SchemaAgreementCheckerTest.VERSION2)))});
        CompletionStage future = checker.run();
        Assertions.assertThatStage(future).isSuccess(b -> Assertions.assertThat((Boolean)b).isTrue());
    }

    @DataProvider
    public static Object[][] malformedPeer() {
        return new Object[][]{{SchemaAgreementCheckerTest.mockPeerRow(null, VERSION2, true, true, true, true)}, {SchemaAgreementCheckerTest.mockPeerRow(NODE_2_HOST_ID, null, true, true, true, true)}, {SchemaAgreementCheckerTest.mockPeerRow(NODE_2_HOST_ID, VERSION2, false, true, true, true)}, {SchemaAgreementCheckerTest.mockPeerRow(NODE_2_HOST_ID, VERSION2, true, false, true, true)}, {SchemaAgreementCheckerTest.mockPeerRow(NODE_2_HOST_ID, VERSION2, true, true, false, true)}, {SchemaAgreementCheckerTest.mockPeerRow(NODE_2_HOST_ID, VERSION2, true, true, true, false)}};
    }

    @Test
    @UseDataProvider(value="malformedPeer")
    public void should_ignore_malformed_rows(AdminRow malformedPeer) {
        TestSchemaAgreementChecker checker = new TestSchemaAgreementChecker(this.channel, this.context);
        checker.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT schema_version FROM system.local WHERE key='local'", this.mockResult(this.mockLocalRow(SchemaAgreementCheckerTest.VERSION1))), new StubbedQuery("SELECT * FROM system.peers", this.mockResult(malformedPeer))});
        CompletionStage future = checker.run();
        Assertions.assertThatStage(future).isSuccess(b -> Assertions.assertThat((Boolean)b).isTrue());
    }

    @Test
    public void should_reschedule_if_versions_do_not_match_on_first_try() {
        TestSchemaAgreementChecker checker = new TestSchemaAgreementChecker(this.channel, this.context);
        checker.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT schema_version FROM system.local WHERE key='local'", this.mockResult(this.mockLocalRow(SchemaAgreementCheckerTest.VERSION1))), new StubbedQuery("SELECT * FROM system.peers", this.mockResult(this.mockValidPeerRow(SchemaAgreementCheckerTest.VERSION2))), new StubbedQuery("SELECT schema_version FROM system.local WHERE key='local'", this.mockResult(this.mockLocalRow(SchemaAgreementCheckerTest.VERSION1))), new StubbedQuery("SELECT * FROM system.peers", this.mockResult(this.mockValidPeerRow(SchemaAgreementCheckerTest.VERSION1)))});
        CompletionStage future = checker.run();
        Assertions.assertThatStage(future).isSuccess(b -> Assertions.assertThat((Boolean)b).isTrue());
    }

    @Test
    public void should_fail_if_versions_do_not_match_after_timeout() {
        Mockito.when((Object)this.defaultConfig.getDuration((DriverOption)DefaultDriverOption.CONTROL_CONNECTION_AGREEMENT_TIMEOUT)).thenReturn((Object)Duration.ofNanos(10L));
        TestSchemaAgreementChecker checker = new TestSchemaAgreementChecker(this.channel, this.context);
        checker.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT schema_version FROM system.local WHERE key='local'", this.mockResult(this.mockLocalRow(SchemaAgreementCheckerTest.VERSION1))), new StubbedQuery("SELECT * FROM system.peers", this.mockResult(this.mockValidPeerRow(SchemaAgreementCheckerTest.VERSION1)))});
        CompletionStage future = checker.run();
        Assertions.assertThatStage(future).isSuccess(b -> Assertions.assertThat((Boolean)b).isFalse());
    }

    private AdminRow mockLocalRow(UUID schemaVersion) {
        AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)row.getUuid("host_id")).thenReturn((Object)this.node1.getHostId());
        Mockito.when((Object)row.getUuid("schema_version")).thenReturn((Object)schemaVersion);
        return row;
    }

    private AdminRow mockValidPeerRow(UUID schemaVersion) {
        return SchemaAgreementCheckerTest.mockPeerRow(this.node2.getHostId(), schemaVersion, true, true, true, true);
    }

    private static AdminRow mockPeerRow(UUID hostId, UUID schemaVersion, boolean hasDatacenter, boolean hasRack, boolean hasRpcAddress, boolean hasTokens) {
        AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)row.getUuid("host_id")).thenReturn((Object)hostId);
        Mockito.when((Object)row.isNull("host_id")).thenReturn((Object)(hostId == null ? 1 : 0));
        Mockito.when((Object)row.getUuid("schema_version")).thenReturn((Object)schemaVersion);
        Mockito.when((Object)row.isNull("schema_version")).thenReturn((Object)(schemaVersion == null ? 1 : 0));
        Mockito.when((Object)row.isNull("data_center")).thenReturn((Object)(!hasDatacenter ? 1 : 0));
        Mockito.when((Object)row.isNull("rack")).thenReturn((Object)(!hasRack ? 1 : 0));
        Mockito.when((Object)row.isNull("tokens")).thenReturn((Object)(!hasTokens ? 1 : 0));
        Mockito.when((Object)row.isNull("rpc_address")).thenReturn((Object)(!hasRpcAddress ? 1 : 0));
        Mockito.when((Object)row.isNull("native_address")).thenReturn((Object)true);
        Mockito.when((Object)row.isNull("native_port")).thenReturn((Object)true);
        return row;
    }

    private AdminResult mockResult(AdminRow ... rows) {
        AdminResult result = (AdminResult)Mockito.mock(AdminResult.class);
        Mockito.when((Object)result.iterator()).thenReturn((Object)Iterators.forArray((Object[])rows));
        return result;
    }

    private static class StubbedQuery {
        private final String queryString;
        private final AdminResult result;

        private StubbedQuery(String queryString, AdminResult result) {
            this.queryString = queryString;
            this.result = result;
        }
    }

    private static class TestSchemaAgreementChecker
    extends SchemaAgreementChecker {
        private final Queue<StubbedQuery> queries = new ArrayDeque<StubbedQuery>();

        TestSchemaAgreementChecker(DriverChannel channel, InternalDriverContext context) {
            super(channel, context, "test");
        }

        private void stubQueries(StubbedQuery ... queries) {
            this.queries.addAll(Arrays.asList(queries));
        }

        protected CompletionStage<AdminResult> query(String queryString) {
            StubbedQuery nextQuery = this.queries.poll();
            Assertions.assertThat((Object)nextQuery).isNotNull();
            Assertions.assertThat((String)queryString).isEqualTo(nextQuery.queryString);
            return CompletableFuture.completedFuture(nextQuery.result);
        }
    }
}

