/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.internal.core.channel.ChannelFactory;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.MetadataRefresh;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metadata.RemoveNodeRefresh;
import com.datastax.oss.driver.internal.core.metadata.TestNodeFactory;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoveNodeRefreshTest {
    @Mock
    private InternalDriverContext context;
    @Mock
    protected MetricsFactory metricsFactory;
    @Mock
    private ChannelFactory channelFactory;
    private DefaultNode node1;
    private DefaultNode node2;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getMetricsFactory()).thenReturn((Object)this.metricsFactory);
        Mockito.when((Object)this.context.getChannelFactory()).thenReturn((Object)this.channelFactory);
        this.node1 = TestNodeFactory.newNode(1, this.context);
        this.node2 = TestNodeFactory.newNode(2, this.context);
    }

    @Test
    public void should_remove_existing_node() {
        DefaultMetadata oldMetadata = new DefaultMetadata((Map)ImmutableMap.of((Object)this.node1.getHostId(), (Object)this.node1, (Object)this.node2.getHostId(), (Object)this.node2), Collections.emptyMap(), null, null);
        RemoveNodeRefresh refresh = new RemoveNodeRefresh((InetSocketAddress)this.node2.getBroadcastRpcAddress().get());
        MetadataRefresh.Result result = refresh.compute(oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getNodes()).containsOnlyKeys((Object[])new UUID[]{this.node1.getHostId()});
        Assertions.assertThat((List)result.events).containsExactly(new Object[]{NodeStateEvent.removed((DefaultNode)this.node2)});
    }

    @Test
    public void should_not_remove_nonexistent_node() {
        DefaultMetadata oldMetadata = new DefaultMetadata((Map)ImmutableMap.of((Object)this.node1.getHostId(), (Object)this.node1), Collections.emptyMap(), null, null);
        RemoveNodeRefresh refresh = new RemoveNodeRefresh((InetSocketAddress)this.node2.getBroadcastRpcAddress().get());
        MetadataRefresh.Result result = refresh.compute(oldMetadata, false, this.context);
        Assertions.assertThat((Map)result.newMetadata.getNodes()).containsOnlyKeys((Object[])new UUID[]{this.node1.getHostId()});
        Assertions.assertThat((List)result.events).isEmpty();
    }
}

