/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.metadata.MultiplexingNodeStateListener;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.BDDMockito;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.Strict.class)
public class MultiplexingNodeStateListenerTest {
    @Mock
    private NodeStateListener child1;
    @Mock
    private NodeStateListener child2;
    @Mock
    private Node node;
    @Mock
    private Session session;
    @Mock
    private Appender<ILoggingEvent> appender;
    @Captor
    private ArgumentCaptor<ILoggingEvent> loggingEventCaptor;
    private Logger logger;
    private Level initialLogLevel;

    @Before
    public void addAppenders() {
        this.logger = (Logger)LoggerFactory.getLogger(MultiplexingNodeStateListener.class);
        this.initialLogLevel = this.logger.getLevel();
        this.logger.setLevel(Level.WARN);
        this.logger.addAppender(this.appender);
    }

    @After
    public void removeAppenders() {
        this.logger.detachAppender(this.appender);
        this.logger.setLevel(this.initialLogLevel);
    }

    @Test
    public void should_register() {
        MultiplexingNodeStateListener listener = new MultiplexingNodeStateListener();
        listener.register(this.child1);
        listener.register(this.child2);
        ((AbstractListAssert)Assertions.assertThat((Object)listener).extracting("listeners").asList().hasSize(2)).contains(new Object[]{this.child1, this.child2});
    }

    @Test
    public void should_flatten_child_multiplexing_listener_via_constructor() {
        MultiplexingNodeStateListener listener = new MultiplexingNodeStateListener(new NodeStateListener[]{new MultiplexingNodeStateListener(new NodeStateListener[]{this.child1, this.child2})});
        ((AbstractListAssert)Assertions.assertThat((Object)listener).extracting("listeners").asList().hasSize(2)).contains(new Object[]{this.child1, this.child2});
    }

    @Test
    public void should_flatten_child_multiplexing_listener_via_register() {
        MultiplexingNodeStateListener listener = new MultiplexingNodeStateListener();
        listener.register((NodeStateListener)new MultiplexingNodeStateListener(new NodeStateListener[]{this.child1, this.child2}));
        ((AbstractListAssert)Assertions.assertThat((Object)listener).extracting("listeners").asList().hasSize(2)).contains(new Object[]{this.child1, this.child2});
    }

    @Test
    public void should_notify_onUp() {
        MultiplexingNodeStateListener listener = new MultiplexingNodeStateListener(new NodeStateListener[]{this.child1, this.child2});
        ((NodeStateListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onUp(this.node);
        listener.onUp(this.node);
        ((NodeStateListener)Mockito.verify((Object)this.child1)).onUp(this.node);
        ((NodeStateListener)Mockito.verify((Object)this.child2)).onUp(this.node);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying node state listener child1 of an onUp event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onDown() {
        MultiplexingNodeStateListener listener = new MultiplexingNodeStateListener(new NodeStateListener[]{this.child1, this.child2});
        ((NodeStateListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onDown(this.node);
        listener.onDown(this.node);
        ((NodeStateListener)Mockito.verify((Object)this.child1)).onDown(this.node);
        ((NodeStateListener)Mockito.verify((Object)this.child2)).onDown(this.node);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying node state listener child1 of an onDown event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onAdd() {
        MultiplexingNodeStateListener listener = new MultiplexingNodeStateListener(new NodeStateListener[]{this.child1, this.child2});
        ((NodeStateListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onAdd(this.node);
        listener.onAdd(this.node);
        ((NodeStateListener)Mockito.verify((Object)this.child1)).onAdd(this.node);
        ((NodeStateListener)Mockito.verify((Object)this.child2)).onAdd(this.node);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying node state listener child1 of an onAdd event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onRemove() {
        MultiplexingNodeStateListener listener = new MultiplexingNodeStateListener(new NodeStateListener[]{this.child1, this.child2});
        ((NodeStateListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onRemove(this.node);
        listener.onRemove(this.node);
        ((NodeStateListener)Mockito.verify((Object)this.child1)).onRemove(this.node);
        ((NodeStateListener)Mockito.verify((Object)this.child2)).onRemove(this.node);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying node state listener child1 of an onRemove event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_onSessionReady() {
        MultiplexingNodeStateListener listener = new MultiplexingNodeStateListener(new NodeStateListener[]{this.child1, this.child2});
        ((NodeStateListener)BDDMockito.willThrow((Throwable[])new Throwable[]{new NullPointerException()}).given((Object)this.child1)).onSessionReady(this.session);
        listener.onSessionReady(this.session);
        ((NodeStateListener)Mockito.verify((Object)this.child1)).onSessionReady(this.session);
        ((NodeStateListener)Mockito.verify((Object)this.child2)).onSessionReady(this.session);
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while notifying node state listener child1 of an onSessionReady event. (NullPointerException: null)"});
    }

    @Test
    public void should_notify_close() throws Exception {
        MultiplexingNodeStateListener listener = new MultiplexingNodeStateListener(new NodeStateListener[]{this.child1, this.child2});
        NullPointerException child1Error = new NullPointerException();
        ((NodeStateListener)BDDMockito.willThrow((Throwable[])new Throwable[]{child1Error}).given((Object)this.child1)).close();
        listener.close();
        ((NodeStateListener)Mockito.verify((Object)this.child1)).close();
        ((NodeStateListener)Mockito.verify((Object)this.child2)).close();
        ((Appender)Mockito.verify(this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat(this.loggingEventCaptor.getAllValues().stream().map(ILoggingEvent::getFormattedMessage)).contains((Object[])new String[]{"Unexpected error while closing node state listener child1. (NullPointerException: null)"});
    }
}

