/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.addresstranslation.AddressTranslator;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.addresstranslation.PassThroughAddressTranslator;
import com.datastax.oss.driver.internal.core.adminrequest.AdminResult;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.adminrequest.UnexpectedResponseException;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.control.ControlConnection;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.DefaultTopologyMonitor;
import com.datastax.oss.driver.internal.core.metadata.NodeInfo;
import com.datastax.oss.driver.internal.core.metadata.TestNodeFactory;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterators;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Error;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;

@RunWith(value=DataProviderRunner.class)
public class DefaultTopologyMonitorTest {
    private static final InetSocketAddress ADDRESS2 = new InetSocketAddress("127.0.0.2", 9042);
    @Mock
    private InternalDriverContext context;
    @Mock
    private DriverConfig config;
    @Mock
    private DriverExecutionProfile defaultConfig;
    @Mock
    private ControlConnection controlConnection;
    @Mock
    private DriverChannel channel;
    @Mock
    protected MetricsFactory metricsFactory;
    @Mock
    private Appender<ILoggingEvent> appender;
    @Captor
    private ArgumentCaptor<ILoggingEvent> loggingEventCaptor;
    private DefaultNode node1;
    private DefaultNode node2;
    private TestTopologyMonitor topologyMonitor;
    private Logger logger;
    private Level initialLogLevel;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.context.getMetricsFactory()).thenReturn((Object)this.metricsFactory);
        this.node1 = TestNodeFactory.newNode(1, this.context);
        this.node2 = TestNodeFactory.newNode(2, this.context);
        Mockito.when((Object)this.defaultConfig.getDuration((DriverOption)DefaultDriverOption.CONTROL_CONNECTION_TIMEOUT)).thenReturn((Object)Duration.ofSeconds(1L));
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultConfig);
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        AddressTranslator addressTranslator = (AddressTranslator)Mockito.spy((Object)new PassThroughAddressTranslator((DriverContext)this.context));
        Mockito.when((Object)this.context.getAddressTranslator()).thenReturn((Object)addressTranslator);
        Mockito.when((Object)this.channel.getEndPoint()).thenReturn((Object)this.node1.getEndPoint());
        Mockito.when((Object)this.controlConnection.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.context.getControlConnection()).thenReturn((Object)this.controlConnection);
        this.topologyMonitor = new TestTopologyMonitor(this.context);
        this.logger = (Logger)LoggerFactory.getLogger(DefaultTopologyMonitor.class);
        this.initialLogLevel = this.logger.getLevel();
        this.logger.setLevel(Level.INFO);
        this.logger.addAppender(this.appender);
    }

    @After
    public void teardown() {
        this.logger.detachAppender(this.appender);
        this.logger.setLevel(this.initialLogLevel);
    }

    @Test
    public void should_initialize_control_connection() {
        this.topologyMonitor.init();
        ((ControlConnection)Mockito.verify((Object)this.controlConnection)).init(true, false, true);
    }

    @Test
    public void should_not_refresh_control_node() {
        CompletionStage futureInfo = this.topologyMonitor.refreshNode((Node)this.node1);
        Assertions.assertThatStage(futureInfo).isSuccess(maybeInfo -> Assertions.assertThat((boolean)maybeInfo.isPresent()).isFalse());
    }

    @Test
    public void should_refresh_node_from_peers_if_broadcast_address_is_present() {
        this.node2.broadcastAddress = ADDRESS2;
        this.topologyMonitor.isSchemaV2 = false;
        this.topologyMonitor.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT * FROM system.peers WHERE peer = :address", (Map)ImmutableMap.of((Object)"address", (Object)DefaultTopologyMonitorTest.ADDRESS2.getAddress()), this.mockResult(this.mockPeersRow(2, this.node2.getHostId())))});
        CompletionStage futureInfo = this.topologyMonitor.refreshNode((Node)this.node2);
        Assertions.assertThatStage(futureInfo).isSuccess(maybeInfo -> {
            Assertions.assertThat((boolean)maybeInfo.isPresent()).isTrue();
            NodeInfo info = (NodeInfo)maybeInfo.get();
            Assertions.assertThat((String)info.getDatacenter()).isEqualTo("dc2");
        });
    }

    @Test
    public void should_refresh_node_from_peers_if_broadcast_address_is_present_v2() {
        this.node2.broadcastAddress = ADDRESS2;
        this.topologyMonitor.isSchemaV2 = true;
        this.topologyMonitor.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT * FROM system.peers_v2 WHERE peer = :address and peer_port = :port", (Map)ImmutableMap.of((Object)"address", (Object)DefaultTopologyMonitorTest.ADDRESS2.getAddress(), (Object)"port", (Object)9042), this.mockResult(this.mockPeersV2Row(2, this.node2.getHostId())))});
        CompletionStage futureInfo = this.topologyMonitor.refreshNode((Node)this.node2);
        Assertions.assertThatStage(futureInfo).isSuccess(maybeInfo -> {
            Assertions.assertThat((boolean)maybeInfo.isPresent()).isTrue();
            NodeInfo info = (NodeInfo)maybeInfo.get();
            Assertions.assertThat((String)info.getDatacenter()).isEqualTo("dc2");
            Assertions.assertThat((int)((InetSocketAddress)info.getBroadcastAddress().get()).getPort()).isEqualTo(7002);
        });
    }

    @Test
    public void should_refresh_node_from_peers_if_broadcast_address_is_not_present() {
        this.topologyMonitor.isSchemaV2 = false;
        this.node2.broadcastAddress = null;
        AdminRow peer3 = this.mockPeersRow(3, UUID.randomUUID());
        AdminRow peer2 = this.mockPeersRow(2, this.node2.getHostId());
        this.topologyMonitor.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT * FROM system.peers", this.mockResult(peer3, peer2))});
        CompletionStage futureInfo = this.topologyMonitor.refreshNode((Node)this.node2);
        Assertions.assertThatStage(futureInfo).isSuccess(maybeInfo -> {
            Assertions.assertThat((boolean)maybeInfo.isPresent()).isTrue();
            NodeInfo info = (NodeInfo)maybeInfo.get();
            Assertions.assertThat((String)info.getDatacenter()).isEqualTo("dc2");
        });
        ((AdminRow)Mockito.verify((Object)peer3)).getUuid("host_id");
        ((AdminRow)Mockito.verify((Object)peer3, (VerificationMode)Mockito.never())).getString(ArgumentMatchers.anyString());
        ((AdminRow)Mockito.verify((Object)peer2, (VerificationMode)Mockito.times((int)2))).getUuid("host_id");
        ((AdminRow)Mockito.verify((Object)peer2)).getString("data_center");
    }

    @Test
    public void should_refresh_node_from_peers_if_broadcast_address_is_not_present_V2() {
        this.topologyMonitor.isSchemaV2 = true;
        this.node2.broadcastAddress = null;
        AdminRow peer3 = this.mockPeersV2Row(3, UUID.randomUUID());
        AdminRow peer2 = this.mockPeersV2Row(2, this.node2.getHostId());
        this.topologyMonitor.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT * FROM system.peers_v2", this.mockResult(peer3, peer2))});
        CompletionStage futureInfo = this.topologyMonitor.refreshNode((Node)this.node2);
        Assertions.assertThatStage(futureInfo).isSuccess(maybeInfo -> {
            Assertions.assertThat((boolean)maybeInfo.isPresent()).isTrue();
            NodeInfo info = (NodeInfo)maybeInfo.get();
            Assertions.assertThat((String)info.getDatacenter()).isEqualTo("dc2");
        });
        ((AdminRow)Mockito.verify((Object)peer3)).getUuid("host_id");
        ((AdminRow)Mockito.verify((Object)peer3, (VerificationMode)Mockito.never())).getString(ArgumentMatchers.anyString());
        ((AdminRow)Mockito.verify((Object)peer2, (VerificationMode)Mockito.times((int)2))).getUuid("host_id");
        ((AdminRow)Mockito.verify((Object)peer2)).getString("data_center");
    }

    @Test
    public void should_get_new_node_from_peers() {
        AdminRow peer3 = this.mockPeersRow(4, UUID.randomUUID());
        AdminRow peer2 = this.mockPeersRow(3, this.node2.getHostId());
        AdminRow peer1 = this.mockPeersRow(2, this.node1.getHostId());
        this.topologyMonitor.isSchemaV2 = false;
        this.topologyMonitor.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT * FROM system.peers", this.mockResult(peer3, peer2, peer1))});
        CompletionStage futureInfo = this.topologyMonitor.getNewNodeInfo(ADDRESS2);
        Assertions.assertThatStage(futureInfo).isSuccess(maybeInfo -> {
            Assertions.assertThat((boolean)maybeInfo.isPresent()).isTrue();
            NodeInfo info = (NodeInfo)maybeInfo.get();
            Assertions.assertThat((String)info.getDatacenter()).isEqualTo("dc2");
        });
        ((AdminRow)Mockito.verify((Object)peer3)).getInetAddress("rpc_address");
        ((AdminRow)Mockito.verify((Object)peer3, (VerificationMode)Mockito.never())).getString(ArgumentMatchers.anyString());
        ((AdminRow)Mockito.verify((Object)peer2)).getInetAddress("rpc_address");
        ((AdminRow)Mockito.verify((Object)peer2, (VerificationMode)Mockito.never())).getString(ArgumentMatchers.anyString());
        ((AdminRow)Mockito.verify((Object)peer1)).getInetAddress("rpc_address");
        ((AdminRow)Mockito.verify((Object)peer1)).getString("data_center");
    }

    @Test
    public void should_get_new_node_from_peers_v2() {
        AdminRow peer3 = this.mockPeersV2Row(4, UUID.randomUUID());
        AdminRow peer2 = this.mockPeersV2Row(3, this.node2.getHostId());
        AdminRow peer1 = this.mockPeersV2Row(2, this.node1.getHostId());
        this.topologyMonitor.isSchemaV2 = true;
        this.topologyMonitor.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT * FROM system.peers_v2", this.mockResult(peer3, peer2, peer1))});
        CompletionStage futureInfo = this.topologyMonitor.getNewNodeInfo(ADDRESS2);
        Assertions.assertThatStage(futureInfo).isSuccess(maybeInfo -> {
            Assertions.assertThat((boolean)maybeInfo.isPresent()).isTrue();
            NodeInfo info = (NodeInfo)maybeInfo.get();
            Assertions.assertThat((String)info.getDatacenter()).isEqualTo("dc2");
        });
        ((AdminRow)Mockito.verify((Object)peer3)).getInetAddress("native_address");
        ((AdminRow)Mockito.verify((Object)peer3, (VerificationMode)Mockito.never())).getString(ArgumentMatchers.anyString());
        ((AdminRow)Mockito.verify((Object)peer2)).getInetAddress("native_address");
        ((AdminRow)Mockito.verify((Object)peer2, (VerificationMode)Mockito.never())).getString(ArgumentMatchers.anyString());
        ((AdminRow)Mockito.verify((Object)peer1)).getInetAddress("native_address");
        ((AdminRow)Mockito.verify((Object)peer1)).getString("data_center");
    }

    @Test
    public void should_refresh_node_list_from_local_and_peers() {
        AdminRow local = this.mockLocalRow(1, this.node1.getHostId());
        AdminRow peer3 = this.mockPeersRow(3, UUID.randomUUID());
        AdminRow peer2 = this.mockPeersRow(2, this.node2.getHostId());
        this.topologyMonitor.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT * FROM system.local", this.mockResult(local)), new StubbedQuery("SELECT * FROM system.peers_v2", Collections.emptyMap(), null, true), new StubbedQuery("SELECT * FROM system.peers", this.mockResult(peer3, peer2))});
        CompletionStage futureInfos = this.topologyMonitor.refreshNodeList();
        Assertions.assertThatStage(futureInfos).isSuccess(infos -> {
            Iterator iterator = infos.iterator();
            NodeInfo info1 = (NodeInfo)iterator.next();
            Assertions.assertThat((Object)info1.getEndPoint()).isEqualTo((Object)this.node1.getEndPoint());
            Assertions.assertThat((String)info1.getDatacenter()).isEqualTo("dc1");
            NodeInfo info3 = (NodeInfo)iterator.next();
            Assertions.assertThat((Object)info3.getEndPoint().resolve()).isEqualTo((Object)new InetSocketAddress("127.0.0.3", 9042));
            Assertions.assertThat((String)info3.getDatacenter()).isEqualTo("dc3");
            NodeInfo info2 = (NodeInfo)iterator.next();
            Assertions.assertThat((Object)info2.getEndPoint()).isEqualTo((Object)this.node2.getEndPoint());
            Assertions.assertThat((String)info2.getDatacenter()).isEqualTo("dc2");
        });
    }

    @Test
    @UseDataProvider(value="columnsToCheckV1")
    public void should_skip_invalid_peers_row(String columnToCheck) {
        this.topologyMonitor.isSchemaV2 = false;
        this.node2.broadcastAddress = ADDRESS2;
        AdminRow peer2 = this.mockPeersRow(2, this.node2.getHostId());
        Mockito.when((Object)peer2.isNull(columnToCheck)).thenReturn((Object)true);
        this.topologyMonitor.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT * FROM system.peers WHERE peer = :address", (Map)ImmutableMap.of((Object)"address", (Object)DefaultTopologyMonitorTest.ADDRESS2.getAddress()), this.mockResult(peer2))});
        CompletionStage futureInfo = this.topologyMonitor.refreshNode((Node)this.node2);
        Assertions.assertThatStage(futureInfo).isSuccess(maybeInfo -> {
            OptionalAssert cfr_ignored_0 = (OptionalAssert)Assertions.assertThat((Optional)maybeInfo).isEmpty();
        });
        ((ObjectAssert)Assertions.assertThat((Object)this.node2.broadcastAddress).isNotNull()).isEqualTo((Object)ADDRESS2);
        this.assertLog(Level.WARN, "[null] Found invalid row in system.peers for peer: /127.0.0.2. This is likely a gossip or snitch issue, this node will be ignored.");
    }

    @Test
    @UseDataProvider(value="columnsToCheckV2")
    public void should_skip_invalid_peers_row_v2(String columnToCheck) {
        this.topologyMonitor.isSchemaV2 = true;
        this.node2.broadcastAddress = ADDRESS2;
        AdminRow peer2 = this.mockPeersV2Row(2, this.node2.getHostId());
        Mockito.when((Object)peer2.isNull(columnToCheck)).thenReturn((Object)true);
        this.topologyMonitor.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT * FROM system.peers_v2 WHERE peer = :address and peer_port = :port", (Map)ImmutableMap.of((Object)"address", (Object)DefaultTopologyMonitorTest.ADDRESS2.getAddress(), (Object)"port", (Object)9042), this.mockResult(peer2))});
        CompletionStage futureInfo = this.topologyMonitor.refreshNode((Node)this.node2);
        Assertions.assertThatStage(futureInfo).isSuccess(maybeInfo -> {
            OptionalAssert cfr_ignored_0 = (OptionalAssert)Assertions.assertThat((Optional)maybeInfo).isEmpty();
        });
        ((ObjectAssert)Assertions.assertThat((Object)this.node2.broadcastAddress).isNotNull()).isEqualTo((Object)ADDRESS2);
        this.assertLog(Level.WARN, "[null] Found invalid row in system.peers_v2 for peer: /127.0.0.2. This is likely a gossip or snitch issue, this node will be ignored.");
    }

    @DataProvider
    public static Object[][] columnsToCheckV1() {
        return new Object[][]{{"rpc_address"}, {"host_id"}, {"data_center"}, {"rack"}, {"tokens"}};
    }

    @DataProvider
    public static Object[][] columnsToCheckV2() {
        return new Object[][]{{"native_address"}, {"native_port"}, {"host_id"}, {"data_center"}, {"rack"}, {"tokens"}};
    }

    @Test
    public void should_stop_executing_queries_once_closed() {
        this.topologyMonitor.close();
        CompletionStage futureInfos = this.topologyMonitor.refreshNodeList();
        Assertions.assertThatStage(futureInfos).isFailed(error -> {
            AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(IllegalStateException.class);
        });
    }

    @Test
    public void should_warn_when_control_host_found_in_system_peers() {
        AdminRow local = this.mockLocalRow(1, this.node1.getHostId());
        AdminRow peer3 = this.mockPeersRow(3, UUID.randomUUID());
        AdminRow peer2 = this.mockPeersRow(2, this.node2.getHostId());
        AdminRow peer1 = this.mockPeersRow(1, this.node2.getHostId());
        this.topologyMonitor.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT * FROM system.local", this.mockResult(local)), new StubbedQuery("SELECT * FROM system.peers_v2", Collections.emptyMap(), null, true), new StubbedQuery("SELECT * FROM system.peers", this.mockResult(peer3, peer2, peer1))});
        CompletionStage futureInfos = this.topologyMonitor.refreshNodeList();
        Assertions.assertThatStage(futureInfos).isSuccess(infos -> {
            AbstractListAssert cfr_ignored_0 = (AbstractListAssert)((IterableAssert)Assertions.assertThat((Iterable)infos).hasSize(3)).extractingResultOf("getEndPoint").containsOnlyOnce(new Object[]{this.node1.getEndPoint()});
        });
        this.assertLog(Level.WARN, "[null] Control node /127.0.0.1:9042 has an entry for itself in system.peers: this entry will be ignored. This is likely due to a misconfiguration; please verify your rpc_address configuration in cassandra.yaml on all nodes in your cluster.");
    }

    @Test
    public void should_warn_when_control_host_found_in_system_peers_v2() {
        AdminRow local = this.mockLocalRow(1, this.node1.getHostId());
        AdminRow peer3 = this.mockPeersRow(3, UUID.randomUUID());
        AdminRow peer2 = this.mockPeersRow(2, this.node2.getHostId());
        AdminRow peer1 = this.mockPeersRow(1, this.node2.getHostId());
        this.topologyMonitor.stubQueries(new StubbedQuery[]{new StubbedQuery("SELECT * FROM system.local", this.mockResult(local)), new StubbedQuery("SELECT * FROM system.peers_v2", this.mockResult(peer3, peer2, peer1))});
        CompletionStage futureInfos = this.topologyMonitor.refreshNodeList();
        Assertions.assertThatStage(futureInfos).isSuccess(infos -> {
            AbstractListAssert cfr_ignored_0 = (AbstractListAssert)((IterableAssert)Assertions.assertThat((Iterable)infos).hasSize(3)).extractingResultOf("getEndPoint").containsOnlyOnce(new Object[]{this.node1.getEndPoint()});
        });
        this.assertLog(Level.WARN, "[null] Control node /127.0.0.1:9042 has an entry for itself in system.peers_v2: this entry will be ignored. This is likely due to a misconfiguration; please verify your rpc_address configuration in cassandra.yaml on all nodes in your cluster.");
    }

    private AdminRow mockLocalRow(int i, UUID hostId) {
        try {
            AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
            Mockito.when((Object)row.isNull("host_id")).thenReturn((Object)(hostId == null ? 1 : 0));
            Mockito.when((Object)row.getUuid("host_id")).thenReturn((Object)hostId);
            Mockito.when((Object)row.getInetAddress("broadcast_address")).thenReturn((Object)InetAddress.getByName("127.0.0." + i));
            Mockito.when((Object)row.isNull("data_center")).thenReturn((Object)false);
            Mockito.when((Object)row.getString("data_center")).thenReturn((Object)("dc" + i));
            Mockito.when((Object)row.getInetAddress("listen_address")).thenReturn((Object)InetAddress.getByName("127.0.0." + i));
            Mockito.when((Object)row.isNull("rack")).thenReturn((Object)false);
            Mockito.when((Object)row.getString("rack")).thenReturn((Object)("rack" + i));
            Mockito.when((Object)row.getString("release_version")).thenReturn((Object)("release_version" + i));
            Mockito.when((Object)row.isNull("rpc_address")).thenReturn((Object)false);
            Mockito.when((Object)row.getInetAddress("rpc_address")).thenReturn((Object)InetAddress.getByName("0.0.0.0"));
            Mockito.when((Object)row.isNull("tokens")).thenReturn((Object)false);
            Mockito.when((Object)row.getSetOfString("tokens")).thenReturn((Object)ImmutableSet.of((Object)("token" + i)));
            Mockito.when((Object)row.contains("peer")).thenReturn((Object)false);
            return row;
        }
        catch (UnknownHostException e) {
            org.assertj.core.api.Assertions.fail((String)"unexpected", (Throwable)e);
            return null;
        }
    }

    private AdminRow mockPeersRow(int i, UUID hostId) {
        try {
            AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
            Mockito.when((Object)row.isNull("host_id")).thenReturn((Object)(hostId == null ? 1 : 0));
            Mockito.when((Object)row.getUuid("host_id")).thenReturn((Object)hostId);
            Mockito.when((Object)row.getInetAddress("peer")).thenReturn((Object)InetAddress.getByName("127.0.0." + i));
            Mockito.when((Object)row.isNull("data_center")).thenReturn((Object)false);
            Mockito.when((Object)row.getString("data_center")).thenReturn((Object)("dc" + i));
            Mockito.when((Object)row.isNull("rack")).thenReturn((Object)false);
            Mockito.when((Object)row.getString("rack")).thenReturn((Object)("rack" + i));
            Mockito.when((Object)row.getString("release_version")).thenReturn((Object)("release_version" + i));
            Mockito.when((Object)row.isNull("rpc_address")).thenReturn((Object)false);
            Mockito.when((Object)row.getInetAddress("rpc_address")).thenReturn((Object)InetAddress.getByName("127.0.0." + i));
            Mockito.when((Object)row.isNull("tokens")).thenReturn((Object)false);
            Mockito.when((Object)row.getSetOfString("tokens")).thenReturn((Object)ImmutableSet.of((Object)("token" + i)));
            Mockito.when((Object)row.contains("peer")).thenReturn((Object)true);
            Mockito.when((Object)row.isNull("native_address")).thenReturn((Object)true);
            Mockito.when((Object)row.isNull("native_port")).thenReturn((Object)true);
            return row;
        }
        catch (UnknownHostException e) {
            org.assertj.core.api.Assertions.fail((String)"unexpected", (Throwable)e);
            return null;
        }
    }

    private AdminRow mockPeersV2Row(int i, UUID hostId) {
        try {
            AdminRow row = (AdminRow)Mockito.mock(AdminRow.class);
            Mockito.when((Object)row.isNull("host_id")).thenReturn((Object)(hostId == null ? 1 : 0));
            Mockito.when((Object)row.getUuid("host_id")).thenReturn((Object)hostId);
            Mockito.when((Object)row.getInetAddress("peer")).thenReturn((Object)InetAddress.getByName("127.0.0." + i));
            Mockito.when((Object)row.getInteger("peer_port")).thenReturn((Object)(7000 + i));
            Mockito.when((Object)row.isNull("data_center")).thenReturn((Object)false);
            Mockito.when((Object)row.getString("data_center")).thenReturn((Object)("dc" + i));
            Mockito.when((Object)row.isNull("rack")).thenReturn((Object)false);
            Mockito.when((Object)row.getString("rack")).thenReturn((Object)("rack" + i));
            Mockito.when((Object)row.getString("release_version")).thenReturn((Object)("release_version" + i));
            Mockito.when((Object)row.isNull("native_address")).thenReturn((Object)false);
            Mockito.when((Object)row.getInetAddress("native_address")).thenReturn((Object)InetAddress.getByName("127.0.0." + i));
            Mockito.when((Object)row.isNull("native_port")).thenReturn((Object)false);
            Mockito.when((Object)row.getInteger("native_port")).thenReturn((Object)9042);
            Mockito.when((Object)row.isNull("tokens")).thenReturn((Object)false);
            Mockito.when((Object)row.getSetOfString("tokens")).thenReturn((Object)ImmutableSet.of((Object)("token" + i)));
            Mockito.when((Object)row.contains("peer")).thenReturn((Object)true);
            Mockito.when((Object)row.contains("peer_port")).thenReturn((Object)true);
            Mockito.when((Object)row.contains("native_port")).thenReturn((Object)true);
            Mockito.when((Object)row.isNull("rpc_address")).thenReturn((Object)true);
            return row;
        }
        catch (UnknownHostException e) {
            org.assertj.core.api.Assertions.fail((String)"unexpected", (Throwable)e);
            return null;
        }
    }

    private AdminResult mockResult(AdminRow ... rows) {
        AdminResult result = (AdminResult)Mockito.mock(AdminResult.class);
        Mockito.when((Object)result.iterator()).thenReturn((Object)Iterators.forArray((Object[])rows));
        return result;
    }

    private void assertLog(Level level, String message) {
        ((Appender)Mockito.verify(this.appender, (VerificationMode)Mockito.atLeast((int)1))).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        List logs = org.assertj.core.api.Assertions.filter((Iterable)this.loggingEventCaptor.getAllValues()).with("level", (Object)level).get();
        Assertions.assertThat((Iterable)logs).hasSize(1);
        Assertions.assertThat((String)((ILoggingEvent)logs.iterator().next()).getFormattedMessage()).contains(new CharSequence[]{message});
    }

    private static class StubbedQuery {
        private final String queryString;
        private final Map<String, Object> parameters;
        private final AdminResult result;
        private final boolean error;

        private StubbedQuery(String queryString, Map<String, Object> parameters, AdminResult result, boolean error) {
            this.queryString = queryString;
            this.parameters = parameters;
            this.result = result;
            this.error = error;
        }

        private StubbedQuery(String queryString, Map<String, Object> parameters, AdminResult result) {
            this(queryString, parameters, result, false);
        }

        private StubbedQuery(String queryString, AdminResult result) {
            this(queryString, Collections.emptyMap(), result);
        }
    }

    private static class TestTopologyMonitor
    extends DefaultTopologyMonitor {
        private final Queue<StubbedQuery> queries = new ArrayDeque<StubbedQuery>();

        private TestTopologyMonitor(InternalDriverContext context) {
            super(context);
            this.port = 9042;
        }

        private void stubQueries(StubbedQuery ... queries) {
            this.queries.addAll(Arrays.asList(queries));
        }

        protected CompletionStage<AdminResult> query(DriverChannel channel, String queryString, Map<String, Object> parameters) {
            StubbedQuery nextQuery = this.queries.poll();
            Assertions.assertThat((Object)nextQuery).isNotNull();
            Assertions.assertThat((String)nextQuery.queryString).isEqualTo(queryString);
            Assertions.assertThat((Map)nextQuery.parameters).isEqualTo(parameters);
            if (nextQuery.error) {
                Error error = new Error(0, "Unknown keyspace/cf pair (system.peers_v2)");
                return CompletableFutures.failedFuture((Throwable)new UnexpectedResponseException(queryString, (Message)error));
            }
            return CompletableFuture.completedFuture(nextQuery.result);
        }
    }
}

