/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.MockedDriverContextFactory;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import java.net.InetSocketAddress;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DefaultNodeTest {
    private final String uuidStr = "1e4687e6-f94e-432e-a792-216f89ef265f";
    private final UUID hostId = UUID.fromString("1e4687e6-f94e-432e-a792-216f89ef265f");
    private final EndPoint endPoint = new DefaultEndPoint(new InetSocketAddress("localhost", 9042));

    @Test
    public void should_have_expected_string_representation() {
        DefaultNode node = new DefaultNode(this.endPoint, (InternalDriverContext)MockedDriverContextFactory.defaultDriverContext());
        node.hostId = this.hostId;
        String expected = String.format("Node(endPoint=localhost/127.0.0.1:9042, hostId=1e4687e6-f94e-432e-a792-216f89ef265f, hashCode=%x)", node.hashCode());
        Assertions.assertThat((String)node.toString()).isEqualTo(expected);
    }

    @Test
    public void should_have_expected_string_representation_if_hostid_is_null() {
        DefaultNode node = new DefaultNode(this.endPoint, (InternalDriverContext)MockedDriverContextFactory.defaultDriverContext());
        node.hostId = null;
        String expected = String.format("Node(endPoint=localhost/127.0.0.1:9042, hostId=null, hashCode=%x)", node.hashCode());
        Assertions.assertThat((String)node.toString()).isEqualTo(expected);
    }
}

