/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.token.Partitioner;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.loadbalancing.BasicLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.loadbalancing.LoadBalancingPolicyTestBase;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class BasicLoadBalancingPolicyQueryPlanTest
extends LoadBalancingPolicyTestBase {
    protected static final CqlIdentifier KEYSPACE = CqlIdentifier.fromInternal((String)"ks");
    protected static final ByteBuffer ROUTING_KEY = Bytes.fromHexString((String)"0xdeadbeef");
    @Mock
    protected Request request;
    @Mock
    protected DefaultSession session;
    @Mock
    protected Metadata metadata;
    @Mock
    protected TokenMap tokenMap;
    @Mock
    protected Token routingToken;
    protected BasicLoadBalancingPolicy policy;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1));
        Mockito.when((Object)this.metadataManager.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.metadata.getTokenMap()).thenAnswer(invocation -> Optional.of(this.tokenMap));
        this.policy = this.createAndInitPolicy();
    }

    @Test
    public void should_use_round_robin_when_no_request() {
        this.request = null;
        this.assertRoundRobinQueryPlans();
        ((TokenMap)BDDMockito.then((Object)this.tokenMap).should(Mockito.never())).getReplicas((CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class), (Token)ArgumentMatchers.any(Token.class));
        ((TokenMap)BDDMockito.then((Object)this.tokenMap).should(Mockito.never())).getReplicas((CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class), (Partitioner)ArgumentMatchers.isNull(), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    @Test
    public void should_use_round_robin_when_no_session() {
        this.session = null;
        this.assertRoundRobinQueryPlans();
        ((Request)BDDMockito.then((Object)this.request).should(Mockito.never())).getRoutingKey();
        ((Request)BDDMockito.then((Object)this.request).should(Mockito.never())).getRoutingToken();
        ((TokenMap)BDDMockito.then((Object)this.tokenMap).should(Mockito.never())).getReplicas((CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class), (Token)ArgumentMatchers.any(Token.class));
        ((TokenMap)BDDMockito.then((Object)this.tokenMap).should(Mockito.never())).getReplicas((CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class), (Partitioner)ArgumentMatchers.isNull(), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    @Test
    public void should_use_round_robin_when_request_has_no_routing_keyspace() {
        Assertions.assertThat((Object)this.request.getKeyspace()).isNull();
        Assertions.assertThat((Object)this.request.getRoutingKeyspace()).isNull();
        this.assertRoundRobinQueryPlans();
        ((Request)BDDMockito.then((Object)this.request).should(Mockito.never())).getRoutingKey();
        ((Request)BDDMockito.then((Object)this.request).should(Mockito.never())).getRoutingToken();
        ((TokenMap)BDDMockito.then((Object)this.tokenMap).should(Mockito.never())).getReplicas((CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class), (Token)ArgumentMatchers.any(Token.class));
        ((TokenMap)BDDMockito.then((Object)this.tokenMap).should(Mockito.never())).getReplicas((CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class), (Partitioner)ArgumentMatchers.isNull(), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    @Test
    public void should_use_round_robin_when_request_has_no_routing_key_or_token() {
        Mockito.when((Object)this.request.getRoutingKeyspace()).thenReturn((Object)KEYSPACE);
        Assertions.assertThat((Comparable)this.request.getRoutingKey()).isNull();
        Assertions.assertThat((Comparable)this.request.getRoutingToken()).isNull();
        this.assertRoundRobinQueryPlans();
        ((TokenMap)BDDMockito.then((Object)this.tokenMap).should(Mockito.never())).getReplicas((CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class), (Token)ArgumentMatchers.any(Token.class));
        ((TokenMap)BDDMockito.then((Object)this.tokenMap).should(Mockito.never())).getReplicas((CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class), (Partitioner)ArgumentMatchers.isNull(), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    @Test
    public void should_use_round_robin_when_token_map_absent() {
        Mockito.when((Object)this.metadata.getTokenMap()).thenReturn(Optional.empty());
        this.assertRoundRobinQueryPlans();
        ((TokenMap)BDDMockito.then((Object)this.tokenMap).should(Mockito.never())).getReplicas((CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class), (Token)ArgumentMatchers.any(Token.class));
        ((TokenMap)BDDMockito.then((Object)this.tokenMap).should(Mockito.never())).getReplicas((CqlIdentifier)ArgumentMatchers.any(CqlIdentifier.class), (Partitioner)ArgumentMatchers.isNull(), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    @Test
    public void should_use_round_robin_when_token_map_returns_no_replicas_using_request_keyspace_and_routing_key() {
        Mockito.when((Object)this.request.getRoutingKeyspace()).thenReturn((Object)KEYSPACE);
        Mockito.when((Object)this.request.getRoutingKey()).thenReturn((Object)ROUTING_KEY);
        Mockito.when((Object)this.tokenMap.getReplicas(KEYSPACE, null, ROUTING_KEY)).thenReturn(Collections.emptySet());
        this.assertRoundRobinQueryPlans();
        ((TokenMap)BDDMockito.then((Object)this.tokenMap).should(Mockito.atLeast((int)1))).getReplicas(KEYSPACE, null, ROUTING_KEY);
    }

    @Test
    public void should_use_round_robin_when_token_map_returns_no_replicas_using_session_keyspace_and_routing_key() {
        BDDMockito.given((Object)this.request.getKeyspace()).willReturn(null);
        BDDMockito.given((Object)this.request.getRoutingKeyspace()).willReturn(null);
        BDDMockito.given((Object)this.session.getKeyspace()).willReturn(Optional.of(KEYSPACE));
        BDDMockito.given((Object)this.request.getRoutingKey()).willReturn((Object)ROUTING_KEY);
        BDDMockito.given((Object)this.tokenMap.getReplicas(KEYSPACE, null, ROUTING_KEY)).willReturn(Collections.emptySet());
        this.assertRoundRobinQueryPlans();
        ((TokenMap)BDDMockito.then((Object)this.tokenMap).should(Mockito.atLeast((int)1))).getReplicas(KEYSPACE, null, ROUTING_KEY);
    }

    @Test
    public void should_use_round_robin_when_token_map_returns_no_replicas_using_request_keyspace_and_routing_token() {
        BDDMockito.given((Object)this.request.getKeyspace()).willReturn(null);
        BDDMockito.given((Object)this.request.getRoutingKeyspace()).willReturn((Object)KEYSPACE);
        BDDMockito.given((Object)this.request.getRoutingToken()).willReturn((Object)this.routingToken);
        BDDMockito.given((Object)this.tokenMap.getReplicas(KEYSPACE, this.routingToken)).willReturn(Collections.emptySet());
        this.assertRoundRobinQueryPlans();
        ((TokenMap)BDDMockito.then((Object)this.tokenMap).should(Mockito.atLeast((int)1))).getReplicas(KEYSPACE, this.routingToken);
    }

    @Test
    public void should_use_round_robin_and_log_error_when_request_throws() {
        BDDMockito.given((Object)this.request.getKeyspace()).willThrow(new Throwable[]{new NullPointerException()});
        this.policy.newQueryPlan(this.request, (Session)this.session);
        ((Appender)Mockito.verify((Object)this.appender)).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        Assertions.assertThat((String)((ILoggingEvent)this.loggingEventCaptor.getValue()).getFormattedMessage()).contains(new CharSequence[]{"Unexpected error while trying to compute query plan"});
    }

    protected void assertRoundRobinQueryPlans() {
        for (int i = 0; i < 3; ++i) {
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4, this.node5});
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node4, this.node5, this.node1});
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node5, this.node1, this.node2});
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node4, this.node5, this.node1, this.node2, this.node3});
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node5, this.node1, this.node2, this.node3, this.node4});
        }
    }

    @Test
    public void should_prioritize_single_replica() {
        Mockito.when((Object)this.request.getRoutingKeyspace()).thenReturn((Object)KEYSPACE);
        Mockito.when((Object)this.request.getRoutingKey()).thenReturn((Object)ROUTING_KEY);
        Mockito.when((Object)this.tokenMap.getReplicas(KEYSPACE, null, ROUTING_KEY)).thenReturn((Object)ImmutableSet.of((Object)this.node3));
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node1, this.node2, this.node4, this.node5});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node2, this.node4, this.node5, this.node1});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node4, this.node5, this.node1, this.node2});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node1, this.node2, this.node4});
        ((BasicLoadBalancingPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.never())).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt());
    }

    @Test
    public void should_prioritize_and_shuffle_replicas() {
        Mockito.when((Object)this.request.getRoutingKeyspace()).thenReturn((Object)KEYSPACE);
        Mockito.when((Object)this.request.getRoutingKey()).thenReturn((Object)ROUTING_KEY);
        Mockito.when((Object)this.tokenMap.getReplicas(KEYSPACE, null, ROUTING_KEY)).thenReturn((Object)ImmutableSet.of((Object)this.node3, (Object)this.node5));
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node1, this.node2, this.node4});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node2, this.node4, this.node1});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node4, this.node1, this.node2});
        ((BasicLoadBalancingPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.times((int)3))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)2));
        ((DefaultSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).getPools();
    }

    protected BasicLoadBalancingPolicy createAndInitPolicy() {
        BasicLoadBalancingPolicy policy = (BasicLoadBalancingPolicy)Mockito.spy((Object)new BasicLoadBalancingPolicy((DriverContext)this.context, "default"){

            protected void shuffleHead(Object[] currentNodes, int headLength) {
            }
        });
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3, (Object)UUID.randomUUID(), (Object)this.node4, (Object)UUID.randomUUID(), (Object)this.node5), this.distanceReporter);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc1")).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4, this.node5});
        return policy;
    }
}

