/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.internal.core.loadbalancing.BasicLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.loadbalancing.LoadBalancingPolicyTestBase;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class BasicLoadBalancingPolicyInitTest
extends LoadBalancingPolicyTestBase {
    @Test
    public void should_use_local_dc_if_provided_via_config() {
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER)).thenReturn((Object)true);
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER)).thenReturn((Object)"dc1");
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1));
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1), this.distanceReporter);
        Assertions.assertThat((String)policy.getLocalDatacenter()).isEqualTo("dc1");
    }

    @Test
    public void should_use_local_dc_if_provided_via_context() {
        Mockito.when((Object)this.context.getLocalDatacenter("default")).thenReturn((Object)"dc1");
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1));
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1), this.distanceReporter);
        Assertions.assertThat((String)policy.getLocalDatacenter()).isEqualTo("dc1");
        ((DriverExecutionProfile)Mockito.verify((Object)this.defaultProfile, (VerificationMode)Mockito.never())).getString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, null);
    }

    @Test
    public void should_not_infer_local_dc_if_not_provided() {
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER)).thenReturn((Object)false);
        Mockito.when((Object)this.node1.getDatacenter()).thenReturn((Object)"dc1");
        Mockito.when((Object)this.node2.getDatacenter()).thenReturn((Object)"dc2");
        Mockito.when((Object)this.node3.getDatacenter()).thenReturn((Object)"dc3");
        BasicLoadBalancingPolicy policy = new BasicLoadBalancingPolicy((DriverContext)this.context, "default"){};
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3), this.distanceReporter);
        Assertions.assertThat((String)policy.getLocalDatacenter()).isNull();
        ((Appender)Mockito.verify((Object)this.appender, (VerificationMode)Mockito.never())).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
    }

    @Test
    public void should_warn_if_contact_points_not_in_local_dc() {
        Mockito.when((Object)this.context.getLocalDatacenter("default")).thenReturn((Object)"dc1");
        Mockito.when((Object)this.node2.getDatacenter()).thenReturn((Object)"dc2");
        Mockito.when((Object)this.node3.getDatacenter()).thenReturn((Object)"dc3");
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node2, (Object)this.node3));
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3), this.distanceReporter);
        ((Appender)Mockito.verify((Object)this.appender, (VerificationMode)Mockito.atLeast((int)1))).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        List warnLogs = Assertions.filter((Iterable)this.loggingEventCaptor.getAllValues()).with("level", (Object)Level.WARN).get();
        Assertions.assertThat((Iterable)warnLogs).hasSize(1);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)((ILoggingEvent)warnLogs.iterator().next()).getFormattedMessage()).contains(new CharSequence[]{"You specified dc1 as the local DC, but some contact points are from a different DC"})).contains(new CharSequence[]{"node2=dc2"})).contains(new CharSequence[]{"node3=dc3"});
    }

    @Test
    public void should_include_nodes_from_local_dc_if_local_dc_set() {
        Mockito.when((Object)this.context.getLocalDatacenter("default")).thenReturn((Object)"dc1");
        Mockito.when((Object)this.node1.getState()).thenReturn((Object)NodeState.UP);
        Mockito.when((Object)this.node2.getState()).thenReturn((Object)NodeState.DOWN);
        Mockito.when((Object)this.node3.getState()).thenReturn((Object)NodeState.UNKNOWN);
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3), this.distanceReporter);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.LOCAL);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc1")).containsExactly((Object[])new Node[]{this.node1, this.node3});
    }

    @Test
    public void should_ignore_nodes_from_remote_dcs_if_local_dc_set() {
        Mockito.when((Object)this.node2.getDatacenter()).thenReturn((Object)"dc2");
        Mockito.when((Object)this.node3.getDatacenter()).thenReturn((Object)"dc3");
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node2));
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3), this.distanceReporter);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.IGNORED);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.IGNORED);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc1")).containsExactly((Object[])new Node[]{this.node1});
    }

    @Test
    public void should_not_ignore_nodes_from_remote_dcs_if_local_dc_not_set() {
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER)).thenReturn((Object)false);
        Mockito.when((Object)this.node2.getDatacenter()).thenReturn((Object)"dc2");
        Mockito.when((Object)this.node3.getDatacenter()).thenReturn((Object)"dc3");
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node2));
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3), this.distanceReporter);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.LOCAL);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc1")).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3});
    }

    @Test
    public void should_ignore_nodes_excluded_by_distance_reporter() {
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node2));
        Mockito.when((Object)this.context.getNodeDistanceEvaluator("default")).thenReturn((node, dc) -> node.equals(this.node1) ? NodeDistance.IGNORED : null);
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3), this.distanceReporter);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.IGNORED);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.LOCAL);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc1")).containsExactly((Object[])new Node[]{this.node2, this.node3});
    }

    @NonNull
    protected BasicLoadBalancingPolicy createPolicy() {
        return new BasicLoadBalancingPolicy((DriverContext)this.context, "default");
    }
}

