/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.loadbalancing.BasicLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.loadbalancing.BasicLoadBalancingPolicyQueryPlanTest;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class BasicLoadBalancingPolicyDcFailoverTest
extends BasicLoadBalancingPolicyQueryPlanTest {
    @Mock
    protected DefaultNode node6;
    @Mock
    protected DefaultNode node7;
    @Mock
    protected DefaultNode node8;
    @Mock
    protected DefaultNode node9;

    @Override
    @Test
    public void should_prioritize_single_replica() {
        Mockito.when((Object)this.request.getRoutingKeyspace()).thenReturn((Object)KEYSPACE);
        Mockito.when((Object)this.request.getRoutingKey()).thenReturn((Object)ROUTING_KEY);
        Mockito.when((Object)this.tokenMap.getReplicas(KEYSPACE, null, ROUTING_KEY)).thenReturn((Object)ImmutableSet.of((Object)this.node3));
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node1, this.node2, this.node4, this.node5, this.node7, this.node8});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node2, this.node1, this.node4, this.node5, this.node7, this.node8});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node1, this.node2, this.node4, this.node5, this.node7, this.node8});
        ((BasicLoadBalancingPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.never())).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1));
        ((BasicLoadBalancingPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.times((int)3))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)4));
    }

    @Override
    @Test
    public void should_prioritize_and_shuffle_replicas() {
        Mockito.when((Object)this.request.getRoutingKeyspace()).thenReturn((Object)KEYSPACE);
        Mockito.when((Object)this.request.getRoutingKey()).thenReturn((Object)ROUTING_KEY);
        Mockito.when((Object)this.tokenMap.getReplicas(KEYSPACE, null, ROUTING_KEY)).thenReturn((Object)ImmutableSet.of((Object)this.node2, (Object)this.node3, (Object)this.node5, (Object)this.node8));
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node1, this.node4, this.node5, this.node7, this.node8});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node1, this.node4, this.node5, this.node7, this.node8});
        Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node1, this.node4, this.node5, this.node7, this.node8});
        ((BasicLoadBalancingPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.times((int)3))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)2));
        ((BasicLoadBalancingPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.times((int)3))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)4));
        ((DefaultSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).getPools();
    }

    @Override
    protected void assertRoundRobinQueryPlans() {
        for (int i = 0; i < 3; ++i) {
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4, this.node5, this.node7, this.node8});
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node2, this.node3, this.node1, this.node4, this.node5, this.node7, this.node8});
            Assertions.assertThat((Iterable)this.policy.newQueryPlan(this.request, (Session)this.session)).containsExactly((Object[])new Node[]{this.node3, this.node1, this.node2, this.node4, this.node5, this.node7, this.node8});
        }
        ((BasicLoadBalancingPolicy)Mockito.verify((Object)this.policy, (VerificationMode)Mockito.atLeast((int)1))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)4));
    }

    @Override
    protected BasicLoadBalancingPolicy createAndInitPolicy() {
        Mockito.when((Object)this.node4.getDatacenter()).thenReturn((Object)"dc2");
        Mockito.when((Object)this.node5.getDatacenter()).thenReturn((Object)"dc2");
        Mockito.when((Object)this.node6.getDatacenter()).thenReturn((Object)"dc2");
        Mockito.when((Object)this.node7.getDatacenter()).thenReturn((Object)"dc3");
        Mockito.when((Object)this.node8.getDatacenter()).thenReturn((Object)"dc3");
        Mockito.when((Object)this.node9.getDatacenter()).thenReturn((Object)"dc3");
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_MAX_NODES_PER_REMOTE_DC)).thenReturn((Object)2);
        Mockito.when((Object)this.defaultProfile.getBoolean((DriverOption)DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_ALLOW_FOR_LOCAL_CONSISTENCY_LEVELS)).thenReturn((Object)false);
        BasicLoadBalancingPolicy policy = (BasicLoadBalancingPolicy)Mockito.spy((Object)new BasicLoadBalancingPolicy((DriverContext)this.context, "default"){

            protected void shuffleHead(Object[] currentNodes, int headLength) {
            }
        });
        ImmutableMap nodes = ImmutableMap.builder().put((Object)UUID.randomUUID(), (Object)this.node1).put((Object)UUID.randomUUID(), (Object)this.node2).put((Object)UUID.randomUUID(), (Object)this.node3).put((Object)UUID.randomUUID(), (Object)this.node4).put((Object)UUID.randomUUID(), (Object)this.node5).put((Object)UUID.randomUUID(), (Object)this.node6).put((Object)UUID.randomUUID(), (Object)this.node7).put((Object)UUID.randomUUID(), (Object)this.node8).put((Object)UUID.randomUUID(), (Object)this.node9).build();
        policy.init((Map)nodes, this.distanceReporter);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc1")).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3});
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc2")).containsExactly((Object[])new Node[]{this.node4, this.node5});
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc3")).containsExactly((Object[])new Node[]{this.node7, this.node8});
        return policy;
    }
}

