/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.data;

import com.datastax.oss.driver.TestDataProviders;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.internal.core.data.IdentifierIndex;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.List;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class IdentifierIndexTest {
    private static final CqlIdentifier Foo = CqlIdentifier.fromInternal((String)"Foo");
    private static final CqlIdentifier foo = CqlIdentifier.fromInternal((String)"foo");
    private static final CqlIdentifier fOO = CqlIdentifier.fromInternal((String)"fOO");
    private IdentifierIndex index = new IdentifierIndex((List)ImmutableList.of((Object)Foo, (Object)foo, (Object)fOO, (Object)Foo, (Object)foo, (Object)fOO));

    @Test
    public void should_find_first_index_of_existing_identifier() {
        Assertions.assertThat((int)this.index.firstIndexOf(Foo)).isEqualTo(0);
        Assertions.assertThat((int)this.index.firstIndexOf(foo)).isEqualTo(1);
        Assertions.assertThat((int)this.index.firstIndexOf(fOO)).isEqualTo(2);
    }

    @Test
    public void should_not_find_index_of_nonexistent_identifier() {
        Assertions.assertThat((int)this.index.firstIndexOf(CqlIdentifier.fromInternal((String)"FOO"))).isEqualTo(-1);
    }

    @Test
    @UseDataProvider(location={TestDataProviders.class}, value="locales")
    public void should_find_first_index_of_case_insensitive_name(Locale locale) {
        Locale def = Locale.getDefault();
        try {
            Locale.setDefault(locale);
            Assertions.assertThat((int)this.index.firstIndexOf("foo")).isEqualTo(0);
            Assertions.assertThat((int)this.index.firstIndexOf("FOO")).isEqualTo(0);
            Assertions.assertThat((int)this.index.firstIndexOf("fOO")).isEqualTo(0);
        }
        finally {
            Locale.setDefault(def);
        }
    }

    @Test
    @UseDataProvider(location={TestDataProviders.class}, value="locales")
    public void should_not_find_first_index_of_nonexistent_case_insensitive_name(Locale locale) {
        Locale def = Locale.getDefault();
        try {
            Locale.setDefault(locale);
            Assertions.assertThat((int)this.index.firstIndexOf("bar")).isEqualTo(-1);
            Assertions.assertThat((int)this.index.firstIndexOf("BAR")).isEqualTo(-1);
            Assertions.assertThat((int)this.index.firstIndexOf("bAR")).isEqualTo(-1);
        }
        finally {
            Locale.setDefault(def);
        }
    }

    @Test
    public void should_find_first_index_of_case_sensitive_name() {
        Assertions.assertThat((int)this.index.firstIndexOf("\"Foo\"")).isEqualTo(0);
        Assertions.assertThat((int)this.index.firstIndexOf("\"foo\"")).isEqualTo(1);
        Assertions.assertThat((int)this.index.firstIndexOf("\"fOO\"")).isEqualTo(2);
    }

    @Test
    public void should_not_find_index_of_nonexistent_case_sensitive_name() {
        Assertions.assertThat((int)this.index.firstIndexOf("\"FOO\"")).isEqualTo(-1);
    }

    @Test
    public void should_find_all_indices_of_existing_identifier() {
        Assertions.assertThat((List)this.index.allIndicesOf(Foo)).containsExactly((Object[])new Integer[]{0, 3});
        Assertions.assertThat((List)this.index.allIndicesOf(foo)).containsExactly((Object[])new Integer[]{1, 4});
        Assertions.assertThat((List)this.index.allIndicesOf(fOO)).containsExactly((Object[])new Integer[]{2, 5});
    }

    @Test
    public void should_not_find_indices_of_nonexistent_identifier() {
        Assertions.assertThat((List)this.index.allIndicesOf(CqlIdentifier.fromInternal((String)"FOO"))).isEmpty();
    }

    @Test
    @UseDataProvider(location={TestDataProviders.class}, value="locales")
    public void should_find_all_indices_of_case_insensitive_name(Locale locale) {
        Locale def = Locale.getDefault();
        try {
            Locale.setDefault(locale);
            Assertions.assertThat((List)this.index.allIndicesOf("foo")).containsExactly((Object[])new Integer[]{0, 1, 2, 3, 4, 5});
            Assertions.assertThat((List)this.index.allIndicesOf("FOO")).containsExactly((Object[])new Integer[]{0, 1, 2, 3, 4, 5});
            Assertions.assertThat((List)this.index.allIndicesOf("fOO")).containsExactly((Object[])new Integer[]{0, 1, 2, 3, 4, 5});
        }
        finally {
            Locale.setDefault(def);
        }
    }

    @Test
    @UseDataProvider(location={TestDataProviders.class}, value="locales")
    public void should_not_find_indices_of_nonexistent_case_insensitive_name(Locale locale) {
        Locale def = Locale.getDefault();
        try {
            Locale.setDefault(locale);
            Assertions.assertThat((List)this.index.allIndicesOf("bar")).isEmpty();
            Assertions.assertThat((List)this.index.allIndicesOf("BAR")).isEmpty();
            Assertions.assertThat((List)this.index.allIndicesOf("bAR")).isEmpty();
        }
        finally {
            Locale.setDefault(def);
        }
    }

    @Test
    public void should_find_all_indices_of_case_sensitive_name() {
        Assertions.assertThat((List)this.index.allIndicesOf("\"Foo\"")).containsExactly((Object[])new Integer[]{0, 3});
        Assertions.assertThat((List)this.index.allIndicesOf("\"foo\"")).containsExactly((Object[])new Integer[]{1, 4});
        Assertions.assertThat((List)this.index.allIndicesOf("\"fOO\"")).containsExactly((Object[])new Integer[]{2, 5});
    }

    @Test
    public void should_not_find_indices_of_nonexistent_case_sensitive_name() {
        Assertions.assertThat((List)this.index.allIndicesOf("\"FOO\"")).isEmpty();
    }
}

