/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.internal.core.cql.ResultSetTestBase;
import com.datastax.oss.driver.internal.core.cql.ResultSets;
import java.util.Iterator;
import java.util.List;
import org.junit.Test;

public class ResultSetsTest
extends ResultSetTestBase {
    @Test
    public void should_create_result_set_from_single_page() {
        AsyncResultSet page1 = this.mockPage(false, 0, 1, 2);
        ResultSet resultSet = ResultSets.newInstance((AsyncResultSet)page1);
        Assertions.assertThat((Iterable)resultSet.getColumnDefinitions()).isSameAs((Object)page1.getColumnDefinitions());
        Assertions.assertThat((Object)resultSet.getExecutionInfo()).isSameAs((Object)page1.getExecutionInfo());
        Assertions.assertThat((List)resultSet.getExecutionInfos()).containsExactly((Object[])new ExecutionInfo[]{page1.getExecutionInfo()});
        Iterator iterator = resultSet.iterator();
        this.assertNextRow(iterator, 0);
        this.assertNextRow(iterator, 1);
        this.assertNextRow(iterator, 2);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    public void should_create_result_set_from_multiple_pages() {
        AsyncResultSet page1 = this.mockPage(true, 0, 1, 2);
        AsyncResultSet page2 = this.mockPage(true, 3, 4, 5);
        AsyncResultSet page3 = this.mockPage(false, 6, 7, 8);
        ResultSetsTest.complete(page1.fetchNextPage(), page2);
        ResultSetsTest.complete(page2.fetchNextPage(), page3);
        ResultSet resultSet = ResultSets.newInstance((AsyncResultSet)page1);
        Assertions.assertThat((boolean)resultSet.iterator().hasNext()).isTrue();
        Assertions.assertThat((Iterable)resultSet.getColumnDefinitions()).isSameAs((Object)page1.getColumnDefinitions());
        Assertions.assertThat((Object)resultSet.getExecutionInfo()).isSameAs((Object)page1.getExecutionInfo());
        Assertions.assertThat((List)resultSet.getExecutionInfos()).containsExactly((Object[])new ExecutionInfo[]{page1.getExecutionInfo()});
        Iterator iterator = resultSet.iterator();
        this.assertNextRow(iterator, 0);
        this.assertNextRow(iterator, 1);
        this.assertNextRow(iterator, 2);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((Object)resultSet.getExecutionInfo()).isEqualTo((Object)page2.getExecutionInfo());
        Assertions.assertThat((List)resultSet.getExecutionInfos()).containsExactly((Object[])new ExecutionInfo[]{page1.getExecutionInfo(), page2.getExecutionInfo()});
        this.assertNextRow(iterator, 3);
        this.assertNextRow(iterator, 4);
        this.assertNextRow(iterator, 5);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((Object)resultSet.getExecutionInfo()).isEqualTo((Object)page3.getExecutionInfo());
        Assertions.assertThat((List)resultSet.getExecutionInfos()).containsExactly((Object[])new ExecutionInfo[]{page1.getExecutionInfo(), page2.getExecutionInfo(), page3.getExecutionInfo()});
        this.assertNextRow(iterator, 6);
        this.assertNextRow(iterator, 7);
        this.assertNextRow(iterator, 8);
    }
}

