/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.internal.core.cql.CqlRequestHandler;
import com.datastax.oss.driver.internal.core.cql.CqlRequestHandlerTestBase;
import com.datastax.oss.driver.internal.core.cql.RequestHandlerTestHarness;
import com.datastax.oss.driver.internal.core.tracker.NoopRequestTracker;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Error;
import java.util.concurrent.CompletionStage;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CqlRequestHandlerTrackerTest
extends CqlRequestHandlerTestBase {
    @Test
    public void should_invoke_request_tracker() {
        try (RequestHandlerTestHarness harness = RequestHandlerTestHarness.builder().withDefaultIdempotence(true).withResponse((Node)this.node1, CqlRequestHandlerTrackerTest.defaultFrameOf((Message)new Error(4098, "mock message"))).withResponse((Node)this.node2, CqlRequestHandlerTrackerTest.defaultFrameOf(CqlRequestHandlerTrackerTest.singleRow())).build();){
            RequestTracker requestTracker = (RequestTracker)Mockito.mock(RequestTracker.class);
            Mockito.when((Object)harness.getContext().getRequestTracker()).thenReturn((Object)requestTracker);
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                ((RequestTracker)Mockito.verify((Object)requestTracker)).onNodeError((Request)ArgumentMatchers.eq((Object)UNDEFINED_IDEMPOTENCE_STATEMENT), (Throwable)ArgumentMatchers.any(BootstrappingException.class), ArgumentMatchers.anyLong(), (DriverExecutionProfile)ArgumentMatchers.any(DriverExecutionProfile.class), (Node)ArgumentMatchers.eq((Object)this.node1), (String)ArgumentMatchers.any(String.class));
                ((RequestTracker)Mockito.verify((Object)requestTracker)).onNodeSuccess((Request)ArgumentMatchers.eq((Object)UNDEFINED_IDEMPOTENCE_STATEMENT), ArgumentMatchers.anyLong(), (DriverExecutionProfile)ArgumentMatchers.any(DriverExecutionProfile.class), (Node)ArgumentMatchers.eq((Object)this.node2), (String)ArgumentMatchers.any(String.class));
                ((RequestTracker)Mockito.verify((Object)requestTracker)).onSuccess((Request)ArgumentMatchers.eq((Object)UNDEFINED_IDEMPOTENCE_STATEMENT), ArgumentMatchers.anyLong(), (DriverExecutionProfile)ArgumentMatchers.any(DriverExecutionProfile.class), (Node)ArgumentMatchers.eq((Object)this.node2), (String)ArgumentMatchers.any(String.class));
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestTracker});
            });
        }
    }

    @Test
    public void should_not_invoke_noop_request_tracker() {
        try (RequestHandlerTestHarness harness = RequestHandlerTestHarness.builder().withDefaultIdempotence(true).withResponse((Node)this.node1, CqlRequestHandlerTrackerTest.defaultFrameOf((Message)new Error(4098, "mock message"))).withResponse((Node)this.node2, CqlRequestHandlerTrackerTest.defaultFrameOf(CqlRequestHandlerTrackerTest.singleRow())).build();){
            RequestTracker requestTracker = (RequestTracker)Mockito.spy((Object)new NoopRequestTracker((DriverContext)harness.getContext()));
            Mockito.when((Object)harness.getContext().getRequestTracker()).thenReturn((Object)requestTracker);
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestTracker}));
        }
    }
}

