/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.NoNodeAvailableException;
import com.datastax.oss.driver.api.core.NodeUnavailableException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.cql.CqlRequestHandler;
import com.datastax.oss.driver.internal.core.cql.CqlRequestHandlerTestBase;
import com.datastax.oss.driver.internal.core.cql.PoolBehavior;
import com.datastax.oss.driver.internal.core.cql.RequestHandlerTestHarness;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.session.RepreparePayload;
import com.datastax.oss.driver.internal.core.util.concurrent.CapturingTimer;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Prepare;
import com.datastax.oss.protocol.internal.response.error.Unprepared;
import com.datastax.oss.protocol.internal.response.result.Prepared;
import com.datastax.oss.protocol.internal.response.result.SetKeyspace;
import com.datastax.oss.protocol.internal.util.Bytes;
import io.netty.util.Timeout;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.mockito.Mockito;

public class CqlRequestHandlerTest
extends CqlRequestHandlerTestBase {
    @Test
    public void should_complete_result_if_first_node_replies_immediately() {
        try (RequestHandlerTestHarness harness = RequestHandlerTestHarness.builder().withResponse((Node)this.node1, CqlRequestHandlerTest.defaultFrameOf(CqlRequestHandlerTest.singleRow())).build();){
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> {
                Iterator rows = resultSet.currentPage().iterator();
                Assertions.assertThat((boolean)rows.hasNext()).isTrue();
                Assertions.assertThat((String)((Row)rows.next()).getString("message")).isEqualTo("hello, world");
                ExecutionInfo executionInfo = resultSet.getExecutionInfo();
                Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node1);
                Assertions.assertThat((List)executionInfo.getErrors()).isEmpty();
                Assertions.assertThat((Map)executionInfo.getIncomingPayload()).isEmpty();
                Assertions.assertThat((Comparable)executionInfo.getPagingState()).isNull();
                Assertions.assertThat((int)executionInfo.getSpeculativeExecutionCount()).isEqualTo(0);
                Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(0);
                Assertions.assertThat((List)executionInfo.getWarnings()).isEmpty();
            });
        }
    }

    @Test
    public void should_fail_if_no_node_available() {
        try (RequestHandlerTestHarness harness = RequestHandlerTestHarness.builder().build();){
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(NoNodeAvailableException.class);
            });
        }
    }

    @Test
    public void should_fail_if_nodes_unavailable() {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder();
        try (RequestHandlerTestHarness harness = harnessBuilder.withEmptyPool((Node)this.node1).withEmptyPool((Node)this.node2).build();){
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                Assertions.assertThat((Throwable)error).isInstanceOf(AllNodesFailedException.class);
                Map allErrors = ((AllNodesFailedException)error).getAllErrors();
                Assertions.assertThat((Map)allErrors).hasSize(2);
                Assertions.assertThat((Map)allErrors).hasEntrySatisfying((Object)this.node1, nodeErrors -> {
                    ObjectAssert cfr_ignored_0 = (ObjectAssert)((ObjectAssert)Assertions.assertThat((List)nodeErrors).singleElement()).isInstanceOf(NodeUnavailableException.class);
                });
                Assertions.assertThat((Map)allErrors).hasEntrySatisfying((Object)this.node2, nodeErrors -> {
                    ObjectAssert cfr_ignored_0 = (ObjectAssert)((ObjectAssert)Assertions.assertThat((List)nodeErrors).singleElement()).isInstanceOf(NodeUnavailableException.class);
                });
            });
        }
    }

    @Test
    public void should_time_out_if_first_node_takes_too_long_to_respond() throws Exception {
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder();
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        node1Behavior.setWriteSuccess();
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            CapturingTimer.CapturedTimeout requestTimeout = harness.nextScheduledTimeout();
            Duration configuredTimeoutDuration = harness.getContext().getConfig().getDefaultProfile().getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT);
            Assertions.assertThat((long)requestTimeout.getDelay(TimeUnit.NANOSECONDS)).isEqualTo(configuredTimeoutDuration.toNanos());
            requestTimeout.task().run((Timeout)requestTimeout);
            Assertions.assertThatStage(resultSetFuture).isFailed(t -> {
                AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)t).isInstanceOf(DriverTimeoutException.class);
            });
        }
    }

    @Test
    public void should_switch_keyspace_on_session_after_successful_use_statement() {
        try (RequestHandlerTestHarness harness = RequestHandlerTestHarness.builder().withResponse((Node)this.node1, CqlRequestHandlerTest.defaultFrameOf((Message)new SetKeyspace("newKeyspace"))).build();){
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)UNDEFINED_IDEMPOTENCE_STATEMENT, harness.getSession(), harness.getContext(), "test").handle();
            Assertions.assertThatStage(resultSetFuture).isSuccess(resultSet -> ((DefaultSession)Mockito.verify((Object)harness.getSession())).setKeyspace(CqlIdentifier.fromInternal((String)"newKeyspace")));
        }
    }

    @Test
    public void should_reprepare_on_the_fly_if_not_prepared() throws InterruptedException {
        ByteBuffer mockId = Bytes.fromHexString((String)"0xffff");
        PreparedStatement preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)preparedStatement.getId()).thenReturn((Object)mockId);
        ColumnDefinitions columnDefinitions = (ColumnDefinitions)Mockito.mock(ColumnDefinitions.class);
        Mockito.when((Object)columnDefinitions.size()).thenReturn((Object)0);
        Mockito.when((Object)preparedStatement.getResultSetDefinitions()).thenReturn((Object)columnDefinitions);
        BoundStatement boundStatement = (BoundStatement)Mockito.mock(BoundStatement.class);
        Mockito.when((Object)boundStatement.getPreparedStatement()).thenReturn((Object)preparedStatement);
        Mockito.when((Object)boundStatement.getValues()).thenReturn(Collections.emptyList());
        Mockito.when((Object)boundStatement.getNowInSeconds()).thenReturn((Object)Integer.MIN_VALUE);
        RequestHandlerTestHarness.Builder harnessBuilder = RequestHandlerTestHarness.builder();
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        harnessBuilder.withResponse((Node)this.node1, CqlRequestHandlerTest.defaultFrameOf(CqlRequestHandlerTest.singleRow()));
        try (RequestHandlerTestHarness harness = harnessBuilder.build();){
            ConcurrentHashMap<ByteBuffer, RepreparePayload> repreparePayloads = new ConcurrentHashMap<ByteBuffer, RepreparePayload>();
            repreparePayloads.put(mockId, new RepreparePayload(mockId, "mock query", null, Collections.emptyMap()));
            Mockito.when((Object)harness.getSession().getRepreparePayloads()).thenReturn(repreparePayloads);
            CompletionStage resultSetFuture = new CqlRequestHandler((Statement)boundStatement, harness.getSession(), harness.getContext(), "test").handle();
            node1Behavior.mockFollowupRequest(Prepare.class, CqlRequestHandlerTest.defaultFrameOf((Message)new Prepared(Bytes.getArray((ByteBuffer)mockId), null, null, null)));
            node1Behavior.setWriteSuccess();
            node1Behavior.setResponseSuccess(CqlRequestHandlerTest.defaultFrameOf((Message)new Unprepared("mock message", Bytes.getArray((ByteBuffer)mockId))));
            Assertions.assertThatStage(resultSetFuture).isSuccess();
        }
    }
}

