/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.typesafe;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.internal.core.config.MockOptions;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultProgrammaticDriverConfigLoaderBuilder;
import com.typesafe.config.ConfigFactory;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DefaultProgrammaticDriverConfigLoaderBuilderTest {
    private static final String FALLBACK_CONFIG = "int1 = 1\nint2 = 2\nprofiles.profile1 { int1 = 11 }";

    @Test
    public void should_override_option() {
        DriverConfigLoader loader = ((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)new DefaultProgrammaticDriverConfigLoaderBuilder(() -> ConfigFactory.parseString((String)FALLBACK_CONFIG), "").withInt((DriverOption)MockOptions.INT1, 2).withInt((DriverOption)MockOptions.INT1, 3)).withInt((DriverOption)MockOptions.INT1, 4)).withInt((DriverOption)MockOptions.INT2, 3)).withInt((DriverOption)MockOptions.INT2, 4)).build();
        DriverConfig config = loader.getInitialConfig();
        Assertions.assertThat((int)config.getDefaultProfile().getInt((DriverOption)MockOptions.INT1)).isEqualTo(4);
        Assertions.assertThat((int)config.getDefaultProfile().getInt((DriverOption)MockOptions.INT2)).isEqualTo(4);
    }

    @Test
    public void should_override_option_in_default_profile() {
        DriverConfigLoader loader = new DefaultProgrammaticDriverConfigLoaderBuilder(() -> ConfigFactory.parseString((String)FALLBACK_CONFIG), "").withInt((DriverOption)MockOptions.INT1, 3).build();
        DriverConfig config = loader.getInitialConfig();
        Assertions.assertThat((int)config.getDefaultProfile().getInt((DriverOption)MockOptions.INT1)).isEqualTo(3);
        Assertions.assertThat((int)config.getDefaultProfile().getInt((DriverOption)MockOptions.INT2)).isEqualTo(2);
    }

    @Test
    public void should_override_option_in_existing_profile() {
        DriverConfigLoader loader = ((ProgrammaticDriverConfigLoaderBuilder)new DefaultProgrammaticDriverConfigLoaderBuilder(() -> ConfigFactory.parseString((String)FALLBACK_CONFIG), "").startProfile("profile1").withInt((DriverOption)MockOptions.INT1, 3)).build();
        DriverConfig config = loader.getInitialConfig();
        Assertions.assertThat((int)config.getDefaultProfile().getInt((DriverOption)MockOptions.INT1)).isEqualTo(1);
        Assertions.assertThat((int)config.getProfile("profile1").getInt((DriverOption)MockOptions.INT1)).isEqualTo(3);
    }

    @Test
    public void should_override_option_in_new_profile() {
        DriverConfigLoader loader = ((ProgrammaticDriverConfigLoaderBuilder)new DefaultProgrammaticDriverConfigLoaderBuilder(() -> ConfigFactory.parseString((String)FALLBACK_CONFIG), "").startProfile("profile2").withInt((DriverOption)MockOptions.INT1, 3)).build();
        DriverConfig config = loader.getInitialConfig();
        Assertions.assertThat((int)config.getDefaultProfile().getInt((DriverOption)MockOptions.INT1)).isEqualTo(1);
        Assertions.assertThat((int)config.getProfile("profile1").getInt((DriverOption)MockOptions.INT1)).isEqualTo(11);
        Assertions.assertThat((int)config.getProfile("profile2").getInt((DriverOption)MockOptions.INT1)).isEqualTo(3);
        Assertions.assertThat((int)config.getProfile("profile2").getInt((DriverOption)MockOptions.INT2)).isEqualTo(2);
    }

    @Test
    public void should_go_back_to_default_profile_when_profile_ends() {
        DriverConfigLoader loader = ((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)new DefaultProgrammaticDriverConfigLoaderBuilder(() -> ConfigFactory.parseString((String)FALLBACK_CONFIG), "").startProfile("profile2").withInt((DriverOption)MockOptions.INT1, 3)).endProfile().withInt((DriverOption)MockOptions.INT1, 4)).build();
        DriverConfig config = loader.getInitialConfig();
        Assertions.assertThat((int)config.getDefaultProfile().getInt((DriverOption)MockOptions.INT1)).isEqualTo(4);
    }

    @Test
    public void should_handle_multiple_programmatic_profiles() {
        DriverConfigLoader loader = ((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)new DefaultProgrammaticDriverConfigLoaderBuilder(() -> ConfigFactory.parseString((String)FALLBACK_CONFIG), "").startProfile("profile2").withInt((DriverOption)MockOptions.INT1, 3)).startProfile("profile3").withInt((DriverOption)MockOptions.INT1, 4)).build();
        DriverConfig config = loader.getInitialConfig();
        Assertions.assertThat((int)config.getProfile("profile2").getInt((DriverOption)MockOptions.INT1)).isEqualTo(3);
        Assertions.assertThat((int)config.getProfile("profile3").getInt((DriverOption)MockOptions.INT1)).isEqualTo(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_honor_root_path() {
        String rootPath = "test-root";
        String propertyKey = rootPath + "." + DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE.getPath();
        try {
            System.setProperty(propertyKey, "42");
            DriverConfigLoader loader = new DefaultProgrammaticDriverConfigLoaderBuilder(DefaultProgrammaticDriverConfigLoaderBuilder.DEFAULT_FALLBACK_SUPPLIER, rootPath).withInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, 1234).build();
            DriverConfig config = loader.getInitialConfig();
            Assertions.assertThat((int)config.getDefaultProfile().getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).isEqualTo(42);
            Assertions.assertThat((int)config.getDefaultProfile().getInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE)).isEqualTo(1234);
        }
        finally {
            System.clearProperty(propertyKey);
        }
    }
}

