/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.map;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.OptionsMap;
import com.datastax.oss.driver.internal.core.config.MockOptions;
import com.datastax.oss.driver.internal.core.config.MockTypedOptions;
import org.junit.Test;

public class MapBasedDriverConfigTest {
    @Test
    public void should_load_minimal_config_with_no_profiles() {
        OptionsMap source = new OptionsMap();
        source.put(MockTypedOptions.INT1, (Object)42);
        DriverConfig config = DriverConfigLoader.fromMap((OptionsMap)source).getInitialConfig();
        Assertions.assertThat(config).hasIntOption(MockOptions.INT1, 42);
    }

    @Test
    public void should_inherit_option_in_profile() {
        OptionsMap source = new OptionsMap();
        source.put(MockTypedOptions.INT1, (Object)42);
        source.put("profile1", MockTypedOptions.INT2, (Object)1);
        DriverConfig config = DriverConfigLoader.fromMap((OptionsMap)source).getInitialConfig();
        Assertions.assertThat(config).hasIntOption(MockOptions.INT1, 42).hasIntOption("profile1", MockOptions.INT1, 42);
    }

    @Test
    public void should_override_option_in_profile() {
        OptionsMap source = new OptionsMap();
        source.put(MockTypedOptions.INT1, (Object)42);
        source.put("profile1", MockTypedOptions.INT1, (Object)43);
        DriverConfig config = DriverConfigLoader.fromMap((OptionsMap)source).getInitialConfig();
        Assertions.assertThat(config).hasIntOption(MockOptions.INT1, 42).hasIntOption("profile1", MockOptions.INT1, 43);
    }

    @Test
    public void should_create_derived_profile_with_new_option() {
        OptionsMap source = new OptionsMap();
        source.put(MockTypedOptions.INT1, (Object)42);
        DriverConfig config = DriverConfigLoader.fromMap((OptionsMap)source).getInitialConfig();
        DriverExecutionProfile base = config.getDefaultProfile();
        DriverExecutionProfile derived = base.withInt((DriverOption)MockOptions.INT2, 43);
        Assertions.assertThat((boolean)base.isDefined((DriverOption)MockOptions.INT2)).isFalse();
        Assertions.assertThat((boolean)derived.isDefined((DriverOption)MockOptions.INT2)).isTrue();
        Assertions.assertThat((int)derived.getInt((DriverOption)MockOptions.INT2)).isEqualTo(43);
    }

    @Test
    public void should_create_derived_profile_overriding_option() {
        OptionsMap source = new OptionsMap();
        source.put(MockTypedOptions.INT1, (Object)42);
        DriverConfig config = DriverConfigLoader.fromMap((OptionsMap)source).getInitialConfig();
        DriverExecutionProfile base = config.getDefaultProfile();
        DriverExecutionProfile derived = base.withInt((DriverOption)MockOptions.INT1, 43);
        Assertions.assertThat((int)base.getInt((DriverOption)MockOptions.INT1)).isEqualTo(42);
        Assertions.assertThat((int)derived.getInt((DriverOption)MockOptions.INT1)).isEqualTo(43);
    }

    @Test
    public void should_create_derived_profile_unsetting_option() {
        OptionsMap source = new OptionsMap();
        source.put(MockTypedOptions.INT1, (Object)42);
        source.put(MockTypedOptions.INT2, (Object)43);
        DriverConfig config = DriverConfigLoader.fromMap((OptionsMap)source).getInitialConfig();
        DriverExecutionProfile base = config.getDefaultProfile();
        DriverExecutionProfile derived = base.without((DriverOption)MockOptions.INT2);
        Assertions.assertThat((int)base.getInt((DriverOption)MockOptions.INT2)).isEqualTo(43);
        Assertions.assertThat((boolean)derived.isDefined((DriverOption)MockOptions.INT2)).isFalse();
    }
}

