/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.cloud;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.internal.core.config.cloud.CloudConfig;
import com.datastax.oss.driver.internal.core.config.cloud.CloudConfigFactory;
import com.datastax.oss.driver.internal.core.ssl.SniSslEngineFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty9.JettyHttpServer;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.google.common.base.Joiner;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CloudConfigFactoryTest {
    private static final String BUNDLE_PATH = "/config/cloud/creds.zip";
    @Rule
    public WireMockRule wireMockRule = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().httpsPort(Integer.valueOf(30443)).dynamicPort().httpServerFactory((HttpServerFactory)new HttpsServerFactory()).needClientAuth(true).keystorePath(this.path("/config/cloud/identity.jks").toString()).keystorePassword("fakePasswordForTests").trustStorePath(this.path("/config/cloud/trustStore.jks").toString()).trustStorePassword("fakePasswordForTests2"));

    @Test
    public void should_load_config_from_local_filesystem() throws Exception {
        URL configFile = this.getClass().getResource(BUNDLE_PATH);
        this.mockProxyMetadataService(this.jsonMetadata());
        CloudConfigFactory cloudConfigFactory = new CloudConfigFactory();
        CloudConfig cloudConfig = cloudConfigFactory.createCloudConfig(configFile);
        this.assertCloudConfig(cloudConfig);
    }

    @Test
    public void should_load_config_from_external_location() throws Exception {
        this.mockHttpSecureBundle(this.secureBundle());
        this.mockProxyMetadataService(this.jsonMetadata());
        URL configFile = new URL("http", "localhost", this.wireMockRule.port(), BUNDLE_PATH);
        CloudConfigFactory cloudConfigFactory = new CloudConfigFactory();
        CloudConfig cloudConfig = cloudConfigFactory.createCloudConfig(configFile);
        this.assertCloudConfig(cloudConfig);
    }

    @Test
    public void should_throw_when_bundle_not_found() throws Exception {
        WireMock.stubFor((MappingBuilder)WireMock.any((UrlPattern)WireMock.urlEqualTo((String)BUNDLE_PATH)).willReturn(WireMock.aResponse().withStatus(404)));
        URL configFile = new URL("http", "localhost", this.wireMockRule.port(), BUNDLE_PATH);
        CloudConfigFactory cloudConfigFactory = new CloudConfigFactory();
        Throwable t = org.assertj.core.api.Assertions.catchThrowable(() -> cloudConfigFactory.createCloudConfig(configFile));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)t).isInstanceOf(FileNotFoundException.class)).hasMessageContaining(configFile.toExternalForm());
    }

    @Test
    public void should_throw_when_bundle_not_readable() throws Exception {
        this.mockHttpSecureBundle("not a zip file".getBytes(StandardCharsets.UTF_8));
        URL configFile = new URL("http", "localhost", this.wireMockRule.port(), BUNDLE_PATH);
        CloudConfigFactory cloudConfigFactory = new CloudConfigFactory();
        Throwable t = org.assertj.core.api.Assertions.catchThrowable(() -> cloudConfigFactory.createCloudConfig(configFile));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)t).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Invalid bundle: missing file config.json");
    }

    @Test
    public void should_throw_when_metadata_not_found() throws Exception {
        this.mockHttpSecureBundle(this.secureBundle());
        WireMock.stubFor((MappingBuilder)WireMock.any((UrlPattern)WireMock.urlPathEqualTo((String)"/metadata")).willReturn(WireMock.aResponse().withStatus(404)));
        URL configFile = new URL("http", "localhost", this.wireMockRule.port(), BUNDLE_PATH);
        CloudConfigFactory cloudConfigFactory = new CloudConfigFactory();
        Throwable t = org.assertj.core.api.Assertions.catchThrowable(() -> cloudConfigFactory.createCloudConfig(configFile));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)t).isInstanceOf(FileNotFoundException.class)).hasMessageContaining("metadata");
    }

    @Test
    public void should_throw_when_metadata_not_readable() throws Exception {
        this.mockHttpSecureBundle(this.secureBundle());
        this.mockProxyMetadataService("not a valid json payload");
        URL configFile = new URL("http", "localhost", this.wireMockRule.port(), BUNDLE_PATH);
        CloudConfigFactory cloudConfigFactory = new CloudConfigFactory();
        Throwable t = org.assertj.core.api.Assertions.catchThrowable(() -> cloudConfigFactory.createCloudConfig(configFile));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)t).isInstanceOf(JsonParseException.class)).hasMessageContaining("Unrecognized token");
    }

    private void mockHttpSecureBundle(byte[] body) {
        WireMock.stubFor((MappingBuilder)WireMock.any((UrlPattern)WireMock.urlEqualTo((String)BUNDLE_PATH)).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/octet-stream"}).withBody(body)));
    }

    private void mockProxyMetadataService(String jsonMetadata) {
        WireMock.stubFor((MappingBuilder)WireMock.any((UrlPattern)WireMock.urlPathEqualTo((String)"/metadata")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withBody(jsonMetadata)));
    }

    private byte[] secureBundle() throws IOException, URISyntaxException {
        return Files.readAllBytes(this.path(BUNDLE_PATH));
    }

    private String jsonMetadata() throws IOException, URISyntaxException {
        return Joiner.on((char)'\n').join(Files.readAllLines(this.path("/config/cloud/metadata.json"), StandardCharsets.UTF_8));
    }

    private Path path(String resource) throws URISyntaxException {
        return Paths.get(this.getClass().getResource(resource).toURI());
    }

    private void assertCloudConfig(CloudConfig config) {
        InetSocketAddress expectedProxyAddress = InetSocketAddress.createUnresolved("localhost", 30002);
        Assertions.assertThat((String)config.getLocalDatacenter()).isEqualTo("dc1");
        Assertions.assertThat((Object)config.getProxyAddress()).isEqualTo((Object)expectedProxyAddress);
        Assertions.assertThat((List)config.getEndPoints()).extracting("proxyAddress").containsOnly(new Object[]{expectedProxyAddress});
        Assertions.assertThat((List)config.getEndPoints()).extracting("serverName").containsExactly(new Object[]{"4ac06655-f861-49f9-881e-3fee22e69b94", "2af7c253-3394-4a0d-bfac-f1ad81b5154d", "b17b6e2a-3f48-4d6a-81c1-20a0a1f3192a"});
        ((ObjectAssert)Assertions.assertThat((Object)config.getSslEngineFactory()).isNotNull()).isInstanceOf(SniSslEngineFactory.class);
    }

    static {
        HttpsURLConnection.setDefaultHostnameVerifier((hostname, sslSession) -> hostname.equals("localhost"));
    }

    private static class HttpsServerFactory
    implements HttpServerFactory {
        private HttpsServerFactory() {
        }

        public HttpServer buildHttpServer(final Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
            return new JettyHttpServer(options, adminRequestHandler, stubRequestHandler){

                protected ServerConnector createServerConnector(String bindAddress, JettySettings jettySettings, int port, NetworkTrafficListener listener, ConnectionFactory ... connectionFactories) {
                    if (port == options.httpsSettings().port()) {
                        SslConnectionFactory sslConnectionFactory = (SslConnectionFactory)connectionFactories[0];
                        SslContextFactory sslContextFactory = sslConnectionFactory.getSslContextFactory();
                        sslContextFactory.setKeyStorePassword(options.httpsSettings().keyStorePassword());
                        connectionFactories = new ConnectionFactory[]{sslConnectionFactory, connectionFactories[1]};
                    }
                    return super.createServerConnector(bindAddress, jettySettings, port, listener, connectionFactories);
                }
            };
        }
    }
}

