/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.channel.ChannelFactory;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.DriverChannelOptions;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.collect.ListMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.MultimapBuilder;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.AbstractBooleanAssert;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import org.mockito.stubbing.OngoingStubbing;

public class MockChannelFactoryHelper {
    private static final int CONNECT_TIMEOUT_MILLIS = 500;
    private final ChannelFactory channelFactory;
    private final InOrder inOrder;
    private final Map<Node, Integer> previous = new HashMap<Node, Integer>();

    public static Builder builder(ChannelFactory channelFactory) {
        return new Builder(channelFactory);
    }

    public MockChannelFactoryHelper(ChannelFactory channelFactory) {
        this.channelFactory = channelFactory;
        this.inOrder = Mockito.inOrder((Object[])new Object[]{channelFactory});
    }

    public void waitForCall(Node node) {
        this.waitForCalls(node, 1);
    }

    public void waitForCalls(Node node, int expected) {
        int fromLastTime = this.previous.getOrDefault(node, 0);
        if (fromLastTime >= expected) {
            this.previous.put(node, fromLastTime - expected);
            return;
        }
        ArgumentCaptor optionsCaptor = ArgumentCaptor.forClass(DriverChannelOptions.class);
        ((ChannelFactory)this.inOrder.verify((Object)this.channelFactory, Mockito.timeout((long)500L).atLeast(expected -= fromLastTime))).connect((Node)ArgumentMatchers.eq((Object)node), (DriverChannelOptions)optionsCaptor.capture());
        int actual = optionsCaptor.getAllValues().size();
        int extras = actual - expected;
        if (extras > 0) {
            this.previous.compute(node, (k, v) -> v == null ? extras : v + extras);
        }
    }

    public void verifyNoMoreCalls() {
        ((ChannelFactory)this.inOrder.verify((Object)this.channelFactory, Mockito.timeout((long)500L).times(0))).connect((Node)ArgumentMatchers.any(Node.class), (DriverChannelOptions)ArgumentMatchers.any(DriverChannelOptions.class));
        HashSet counts = Sets.newHashSet(this.previous.values());
        if (!counts.isEmpty()) {
            Assertions.assertThat((Iterable)counts).containsExactly((Object[])new Integer[]{0});
        }
    }

    public static class Builder {
        private final ChannelFactory channelFactory;
        private final ListMultimap<Node, Object> invocations = MultimapBuilder.hashKeys().arrayListValues().build();

        public Builder(ChannelFactory channelFactory) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)MockUtil.isMock((Object)channelFactory)).as("expected a mock", new Object[0])).isTrue();
            Mockito.verifyZeroInteractions((Object[])new Object[]{channelFactory});
            this.channelFactory = channelFactory;
        }

        public Builder success(Node node, DriverChannel channel) {
            this.invocations.put((Object)node, (Object)channel);
            return this;
        }

        public Builder failure(Node node, String error) {
            this.invocations.put((Object)node, (Object)new Exception(error));
            return this;
        }

        public Builder failure(Node node, Throwable error) {
            this.invocations.put((Object)node, (Object)error);
            return this;
        }

        public Builder pending(Node node, CompletableFuture<DriverChannel> future) {
            this.invocations.put((Object)node, future);
            return this;
        }

        public MockChannelFactoryHelper build() {
            this.stub();
            return new MockChannelFactoryHelper(this.channelFactory);
        }

        private void stub() {
            for (Node node : this.invocations.keySet()) {
                ArrayDeque<CompletionStage> results = new ArrayDeque<CompletionStage>();
                for (Object object : this.invocations.get((Object)node)) {
                    if (object instanceof DriverChannel) {
                        results.add(CompletableFuture.completedFuture((DriverChannel)object));
                        continue;
                    }
                    if (object instanceof Throwable) {
                        results.add(CompletableFutures.failedFuture((Throwable)((Throwable)object)));
                        continue;
                    }
                    if (object instanceof CompletableFuture) {
                        CompletionStage future = (CompletionStage)object;
                        results.add(future);
                        continue;
                    }
                    org.assertj.core.api.Assertions.fail((String)("unexpected type: " + object.getClass()));
                }
                if (results.size() <= 0) continue;
                CompletionStage first = (CompletionStage)results.poll();
                OngoingStubbing ongoingStubbing = Mockito.when((Object)this.channelFactory.connect((Node)ArgumentMatchers.eq((Object)node), (DriverChannelOptions)ArgumentMatchers.any(DriverChannelOptions.class))).thenReturn((Object)first);
                for (CompletionStage result : results) {
                    ongoingStubbing.thenReturn((Object)result);
                }
            }
        }
    }
}

