/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.internal.core.channel.ChannelHandlerTestBase;
import com.datastax.oss.driver.internal.core.channel.ConnectInitHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Before;
import org.junit.Test;

public class ConnectInitHandlerTest
extends ChannelHandlerTestBase {
    private TestHandler handler;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.handler = new TestHandler();
        this.channel.pipeline().addLast(new ChannelHandler[]{this.handler});
    }

    @Test
    public void should_call_onRealConnect_when_connection_succeeds() {
        Assertions.assertThat((boolean)this.handler.hasConnected).isFalse();
        this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        Assertions.assertThat((boolean)this.handler.hasConnected).isTrue();
    }

    @Test
    public void should_not_complete_connect_future_before_triggered_by_handler() {
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        Assertions.assertThat((boolean)connectFuture.isDone()).isFalse();
    }

    @Test
    public void should_complete_connect_future_when_handler_completes() {
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        this.handler.setConnectSuccess();
        Assertions.assertThat((boolean)connectFuture.isSuccess()).isTrue();
    }

    @Test
    public void should_remove_handler_from_pipeline_when_handler_completes() {
        this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        this.handler.setConnectSuccess();
        Assertions.assertThat((Object)((Object)((TestHandler)this.channel.pipeline().get(TestHandler.class)))).isNull();
    }

    @Test
    public void should_fail_connect_future_when_handler_fails() {
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        Exception exception = new Exception("test");
        this.handler.setConnectFailure(exception);
        Assertions.assertThat(connectFuture).isFailed(e -> {
            AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isEqualTo((Object)exception);
        });
    }

    @Test
    public void should_ignore_subsequent_calls_if_handler_already_failed() {
        ChannelFuture connectFuture = this.channel.connect((SocketAddress)new InetSocketAddress("localhost", 9042));
        Exception exception = new Exception("test");
        this.handler.setConnectFailure(exception);
        this.handler.setConnectFailure(new Exception("test2"));
        this.handler.setConnectSuccess();
        Assertions.assertThat(connectFuture).isFailed(e -> {
            AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isEqualTo((Object)exception);
        });
    }

    static class TestHandler
    extends ConnectInitHandler {
        boolean hasConnected;

        TestHandler() {
        }

        protected void onRealConnect(ChannelHandlerContext ctx) {
            this.hasConnected = true;
        }
    }
}

