/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;

public class ChannelHandlerTestBase {
    protected EmbeddedChannel channel;

    @Before
    public void setup() {
        this.channel = new EmbeddedChannel();
    }

    protected Frame readInboundFrame() {
        this.channel.runPendingTasks();
        Object o = this.channel.readInbound();
        Assertions.assertThat((Object)o).isInstanceOf(Frame.class);
        return (Frame)o;
    }

    protected Frame readOutboundFrame() {
        this.channel.runPendingTasks();
        Object o = this.channel.readOutbound();
        Assertions.assertThat((Object)o).isInstanceOf(Frame.class);
        return (Frame)o;
    }

    protected void assertNoOutboundFrame() {
        this.channel.runPendingTasks();
        Object o = this.channel.readOutbound();
        Assertions.assertThat((Object)o).isNull();
    }

    protected void writeInboundFrame(Frame responseFrame) {
        this.channel.writeInbound(new Object[]{responseFrame});
    }

    protected void writeInboundFrame(Frame requestFrame, Message response) {
        this.channel.writeInbound(new Object[]{this.buildInboundFrame(requestFrame, response)});
    }

    protected Frame buildInboundFrame(Frame requestFrame, Message response) {
        return Frame.forResponse((int)requestFrame.protocolVersion, (int)requestFrame.streamId, null, (Map)requestFrame.customPayload, Collections.emptyList(), (Message)response);
    }
}

