/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.TestResponses;
import com.datastax.oss.driver.internal.core.channel.ChannelFactory;
import com.datastax.oss.driver.internal.core.channel.ChannelFactoryTestBase;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.DriverChannelOptions;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopNodeMetricUpdater;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Ready;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.junit.Test;
import org.mockito.Mockito;

public class ChannelFactorySupportedOptionsTest
extends ChannelFactoryTestBase {
    @Test
    public void should_query_supported_options_on_first_channel() throws Throwable {
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)false);
        Mockito.when((Object)this.protocolVersionRegistry.highestNonBeta()).thenReturn((Object)DefaultProtocolVersion.V4);
        ChannelFactory factory = this.newChannelFactory();
        CompletionStage channelFuture1 = factory.connect(SERVER_ADDRESS, DriverChannelOptions.DEFAULT, (NodeMetricUpdater)NoopNodeMetricUpdater.INSTANCE);
        this.writeInboundFrame(this.readOutboundFrame(), (Message)TestResponses.supportedResponse("mock_key", "mock_value"));
        this.writeInboundFrame(this.readOutboundFrame(), (Message)new Ready());
        this.writeInboundFrame(this.readOutboundFrame(), (Message)TestResponses.clusterNameResponse("mockClusterName"));
        Assertions.assertThatStage(channelFuture1).isSuccess();
        DriverChannel channel1 = (DriverChannel)channelFuture1.toCompletableFuture().get();
        org.assertj.core.api.Assertions.assertThat((Map)channel1.getOptions()).containsKey((Object)"mock_key");
        org.assertj.core.api.Assertions.assertThat((List)((List)channel1.getOptions().get("mock_key"))).containsOnly((Object[])new String[]{"mock_value"});
        CompletionStage channelFuture2 = factory.connect(SERVER_ADDRESS, DriverChannelOptions.DEFAULT, (NodeMetricUpdater)NoopNodeMetricUpdater.INSTANCE);
        this.writeInboundFrame(this.readOutboundFrame(), (Message)new Ready());
        this.writeInboundFrame(this.readOutboundFrame(), (Message)TestResponses.clusterNameResponse("mockClusterName"));
        Assertions.assertThatStage(channelFuture2).isSuccess();
        DriverChannel channel2 = (DriverChannel)channelFuture2.toCompletableFuture().get();
        org.assertj.core.api.Assertions.assertThat((Map)channel2.getOptions()).isNull();
    }
}

