/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.UnsupportedProtocolVersionException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.TestResponses;
import com.datastax.oss.driver.internal.core.channel.ChannelFactory;
import com.datastax.oss.driver.internal.core.channel.ChannelFactoryTestBase;
import com.datastax.oss.driver.internal.core.channel.DriverChannelOptions;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopNodeMetricUpdater;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Options;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.Ready;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Test;
import org.mockito.Mockito;

public class ChannelFactoryProtocolNegotiationTest
extends ChannelFactoryTestBase {
    @Test
    public void should_succeed_if_version_specified_and_supported_by_server() {
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)true);
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)"V4");
        Mockito.when((Object)this.protocolVersionRegistry.fromName("V4")).thenReturn((Object)DefaultProtocolVersion.V4);
        ChannelFactory factory = this.newChannelFactory();
        CompletionStage channelFuture = factory.connect(SERVER_ADDRESS, DriverChannelOptions.DEFAULT, (NodeMetricUpdater)NoopNodeMetricUpdater.INSTANCE);
        this.completeSimpleChannelInit();
        Assertions.assertThatStage(channelFuture).isSuccess(channel -> Assertions.assertThat((String)channel.getClusterName()).isEqualTo("mockClusterName"));
        Assertions.assertThat((Object)factory.protocolVersion).isEqualTo((Object)DefaultProtocolVersion.V4);
    }

    @Test
    @UseDataProvider(value="unsupportedProtocolCodes")
    public void should_fail_if_version_specified_and_not_supported_by_server(int errorCode) {
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)true);
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)"V4");
        Mockito.when((Object)this.protocolVersionRegistry.fromName("V4")).thenReturn((Object)DefaultProtocolVersion.V4);
        ChannelFactory factory = this.newChannelFactory();
        CompletionStage channelFuture = factory.connect(SERVER_ADDRESS, DriverChannelOptions.DEFAULT, (NodeMetricUpdater)NoopNodeMetricUpdater.INSTANCE);
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Options.class);
        this.writeInboundFrame(requestFrame, (Message)TestResponses.supportedResponse("mock_key", "mock_value"));
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((int)requestFrame.protocolVersion).isEqualTo(DefaultProtocolVersion.V4.getCode());
        this.writeInboundFrame(requestFrame, (Message)new Error(errorCode, "Invalid or unsupported protocol version"));
        Assertions.assertThatStage(channelFuture).isFailed(e -> {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(UnsupportedProtocolVersionException.class)).hasMessageContaining("Host does not support protocol version V4");
            Assertions.assertThat((List)((UnsupportedProtocolVersionException)e).getAttemptedVersions()).containsExactly((Object[])new ProtocolVersion[]{DefaultProtocolVersion.V4});
        });
    }

    @Test
    public void should_fail_if_version_specified_and_considered_beta_by_server() {
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)true);
        Mockito.when((Object)this.defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)"V5");
        Mockito.when((Object)this.protocolVersionRegistry.fromName("V5")).thenReturn((Object)DefaultProtocolVersion.V5);
        ChannelFactory factory = this.newChannelFactory();
        CompletionStage channelFuture = factory.connect(SERVER_ADDRESS, DriverChannelOptions.DEFAULT, (NodeMetricUpdater)NoopNodeMetricUpdater.INSTANCE);
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Options.class);
        this.writeInboundFrame(requestFrame, (Message)TestResponses.supportedResponse("mock_key", "mock_value"));
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((int)requestFrame.protocolVersion).isEqualTo(DefaultProtocolVersion.V5.getCode());
        this.writeInboundFrame(requestFrame, (Message)new Error(10, "Beta version of the protocol used (5/v5-beta), but USE_BETA flag is unset"));
        Assertions.assertThatStage(channelFuture).isFailed(e -> {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(UnsupportedProtocolVersionException.class)).hasMessageContaining("Host does not support protocol version V5");
            Assertions.assertThat((List)((UnsupportedProtocolVersionException)e).getAttemptedVersions()).containsExactly((Object[])new ProtocolVersion[]{DefaultProtocolVersion.V5});
        });
    }

    @Test
    public void should_succeed_if_version_not_specified_and_server_supports_latest_supported() {
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)false);
        Mockito.when((Object)this.protocolVersionRegistry.highestNonBeta()).thenReturn((Object)DefaultProtocolVersion.V4);
        ChannelFactory factory = this.newChannelFactory();
        CompletionStage channelFuture = factory.connect(SERVER_ADDRESS, DriverChannelOptions.DEFAULT, (NodeMetricUpdater)NoopNodeMetricUpdater.INSTANCE);
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Options.class);
        this.writeInboundFrame(requestFrame, (Message)TestResponses.supportedResponse("mock_key", "mock_value"));
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((int)requestFrame.protocolVersion).isEqualTo(DefaultProtocolVersion.V4.getCode());
        this.writeInboundFrame(requestFrame, (Message)new Ready());
        requestFrame = this.readOutboundFrame();
        this.writeInboundFrame(requestFrame, (Message)TestResponses.clusterNameResponse("mockClusterName"));
        Assertions.assertThatStage(channelFuture).isSuccess(channel -> Assertions.assertThat((String)channel.getClusterName()).isEqualTo("mockClusterName"));
        Assertions.assertThat((Object)factory.protocolVersion).isEqualTo((Object)DefaultProtocolVersion.V4);
    }

    @Test
    @UseDataProvider(value="unsupportedProtocolCodes")
    public void should_negotiate_if_version_not_specified_and_server_supports_legacy(int errorCode) {
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)false);
        Mockito.when((Object)this.protocolVersionRegistry.highestNonBeta()).thenReturn((Object)DefaultProtocolVersion.V4);
        Mockito.when((Object)this.protocolVersionRegistry.downgrade((ProtocolVersion)DefaultProtocolVersion.V4)).thenReturn(Optional.of(DefaultProtocolVersion.V3));
        ChannelFactory factory = this.newChannelFactory();
        CompletionStage channelFuture = factory.connect(SERVER_ADDRESS, DriverChannelOptions.DEFAULT, (NodeMetricUpdater)NoopNodeMetricUpdater.INSTANCE);
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Options.class);
        this.writeInboundFrame(requestFrame, (Message)TestResponses.supportedResponse("mock_key", "mock_value"));
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((int)requestFrame.protocolVersion).isEqualTo(DefaultProtocolVersion.V4.getCode());
        this.writeInboundFrame(requestFrame, (Message)new Error(errorCode, "Invalid or unsupported protocol version"));
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Options.class);
        this.writeInboundFrame(requestFrame, (Message)TestResponses.supportedResponse("mock_key", "mock_value"));
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((int)requestFrame.protocolVersion).isEqualTo(DefaultProtocolVersion.V3.getCode());
        this.writeInboundFrame(requestFrame, (Message)new Ready());
        requestFrame = this.readOutboundFrame();
        this.writeInboundFrame(requestFrame, (Message)TestResponses.clusterNameResponse("mockClusterName"));
        Assertions.assertThatStage(channelFuture).isSuccess(channel -> Assertions.assertThat((String)channel.getClusterName()).isEqualTo("mockClusterName"));
        Assertions.assertThat((Object)factory.protocolVersion).isEqualTo((Object)DefaultProtocolVersion.V3);
    }

    @Test
    @UseDataProvider(value="unsupportedProtocolCodes")
    public void should_fail_if_negotiation_finds_no_matching_version(int errorCode) {
        Mockito.when((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.PROTOCOL_VERSION)).thenReturn((Object)false);
        Mockito.when((Object)this.protocolVersionRegistry.highestNonBeta()).thenReturn((Object)DefaultProtocolVersion.V4);
        Mockito.when((Object)this.protocolVersionRegistry.downgrade((ProtocolVersion)DefaultProtocolVersion.V4)).thenReturn(Optional.of(DefaultProtocolVersion.V3));
        Mockito.when((Object)this.protocolVersionRegistry.downgrade((ProtocolVersion)DefaultProtocolVersion.V3)).thenReturn(Optional.empty());
        ChannelFactory factory = this.newChannelFactory();
        CompletionStage channelFuture = factory.connect(SERVER_ADDRESS, DriverChannelOptions.DEFAULT, (NodeMetricUpdater)NoopNodeMetricUpdater.INSTANCE);
        Frame requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Options.class);
        this.writeInboundFrame(requestFrame, (Message)TestResponses.supportedResponse("mock_key", "mock_value"));
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((int)requestFrame.protocolVersion).isEqualTo(DefaultProtocolVersion.V4.getCode());
        this.writeInboundFrame(requestFrame, (Message)new Error(errorCode, "Invalid or unsupported protocol version"));
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((Object)requestFrame.message).isInstanceOf(Options.class);
        this.writeInboundFrame(requestFrame, (Message)TestResponses.supportedResponse("mock_key", "mock_value"));
        requestFrame = this.readOutboundFrame();
        Assertions.assertThat((int)requestFrame.protocolVersion).isEqualTo(DefaultProtocolVersion.V3.getCode());
        this.writeInboundFrame(requestFrame, (Message)new Error(errorCode, "Invalid or unsupported protocol version"));
        Assertions.assertThatStage(channelFuture).isFailed(e -> {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(UnsupportedProtocolVersionException.class)).hasMessageContaining("Protocol negotiation failed: could not find a common version (attempted: [V4, V3])");
            Assertions.assertThat((List)((UnsupportedProtocolVersionException)e).getAttemptedVersions()).containsExactly((Object[])new ProtocolVersion[]{DefaultProtocolVersion.V4, DefaultProtocolVersion.V3});
        });
    }

    @DataProvider
    public static Object[][] unsupportedProtocolCodes() {
        return new Object[][]{{10}, {0}};
    }
}

