/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import io.netty.util.concurrent.Future;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public class NettyFutureAssert<V>
extends AbstractAssert<NettyFutureAssert<V>, Future<V>> {
    public NettyFutureAssert(Future<V> actual) {
        super(actual, NettyFutureAssert.class);
    }

    public NettyFutureAssert isNotDone() {
        Assertions.assertThat((boolean)((Future)this.actual).isDone()).isFalse();
        return this;
    }

    public NettyFutureAssert<V> isSuccess(Consumer<V> valueAssertions) {
        try {
            Object value = ((Future)this.actual).get(100L, TimeUnit.MILLISECONDS);
            valueAssertions.accept(value);
        }
        catch (TimeoutException e) {
            Assertions.fail((String)"Future did not complete within the timeout");
        }
        catch (Throwable t) {
            Assertions.fail((String)"Unexpected error while waiting on the future", (Throwable)t);
        }
        return this;
    }

    public NettyFutureAssert<V> isSuccess() {
        return this.isSuccess(v -> {});
    }

    public NettyFutureAssert isFailed(Consumer<Throwable> failureAssertions) {
        try {
            ((Future)this.actual).get(100L, TimeUnit.MILLISECONDS);
            Assertions.fail((String)"Expected future to fail");
        }
        catch (TimeoutException e) {
            Assertions.fail((String)"Future did not fail within the timeout");
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"Interrupted while waiting for future to fail");
        }
        catch (ExecutionException e) {
            failureAssertions.accept(e.getCause());
        }
        return this;
    }

    public NettyFutureAssert isFailed() {
        return this.isFailed(f -> {});
    }
}

