/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;

public class CompletionStageAssert<V>
extends AbstractAssert<CompletionStageAssert<V>, CompletionStage<V>> {
    public CompletionStageAssert(CompletionStage<V> actual) {
        super(actual, CompletionStageAssert.class);
    }

    public CompletionStageAssert<V> isSuccess(Consumer<V> valueAssertions) {
        try {
            Object value = ((CompletionStage)this.actual).toCompletableFuture().get(2L, TimeUnit.SECONDS);
            valueAssertions.accept(value);
        }
        catch (TimeoutException e) {
            Assertions.fail((String)"Future did not complete within the timeout");
        }
        catch (Throwable t) {
            Assertions.fail((String)"Unexpected error while waiting on the future", (Throwable)t);
        }
        return this;
    }

    public CompletionStageAssert<V> isSuccess() {
        return this.isSuccess(v -> {});
    }

    public CompletionStageAssert<V> isFailed(Consumer<Throwable> failureAssertions) {
        try {
            ((CompletionStage)this.actual).toCompletableFuture().get(2L, TimeUnit.SECONDS);
            Assertions.fail((String)"Expected completion stage to fail");
        }
        catch (TimeoutException e) {
            Assertions.fail((String)"Future did not complete within the timeout");
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"Interrupted while waiting for future to fail");
        }
        catch (ExecutionException e) {
            failureAssertions.accept(e.getCause());
        }
        return this;
    }

    public CompletionStageAssert<V> isFailed() {
        return this.isFailed(f -> {});
    }

    public CompletionStageAssert<V> isCancelled() {
        boolean cancelled = false;
        try {
            ((CompletionStage)this.actual).toCompletableFuture().get(2L, TimeUnit.SECONDS);
        }
        catch (CancellationException e) {
            cancelled = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!cancelled) {
            Assertions.fail((String)"Expected completion stage to be cancelled");
        }
        return this;
    }

    public CompletionStageAssert<V> isNotCancelled() {
        boolean cancelled = false;
        try {
            ((CompletionStage)this.actual).toCompletableFuture().get(2L, TimeUnit.SECONDS);
        }
        catch (CancellationException e) {
            cancelled = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cancelled) {
            Assertions.fail((String)"Expected completion stage not to be cancelled");
        }
        return this;
    }

    public CompletionStageAssert<V> isDone() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((CompletionStage)this.actual).toCompletableFuture().isDone()).overridingErrorMessage("Expected completion stage to be done", new Object[0])).isTrue();
        return this;
    }

    public CompletionStageAssert<V> isNotDone() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((CompletionStage)this.actual).toCompletableFuture().isDone()).overridingErrorMessage("Expected completion stage not to be done", new Object[0])).isFalse();
        return this;
    }
}

