/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.metadata;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.metadata.SafeInitNodeStateListener;
import com.datastax.oss.driver.api.core.session.Session;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SafeInitNodeStateListenerTest {
    @Mock
    private NodeStateListener delegate;
    @Mock
    private Node node;
    @Mock
    private Session session;

    @Test
    public void should_replay_init_events() {
        SafeInitNodeStateListener wrapper = new SafeInitNodeStateListener(this.delegate, true);
        wrapper.onAdd(this.node);
        wrapper.onUp(this.node);
        wrapper.onSessionReady(this.session);
        wrapper.onDown(this.node);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.delegate});
        ((NodeStateListener)inOrder.verify((Object)this.delegate)).onSessionReady(this.session);
        ((NodeStateListener)inOrder.verify((Object)this.delegate)).onAdd(this.node);
        ((NodeStateListener)inOrder.verify((Object)this.delegate)).onUp(this.node);
        ((NodeStateListener)inOrder.verify((Object)this.delegate)).onDown(this.node);
    }

    @Test
    public void should_discard_init_events() {
        SafeInitNodeStateListener wrapper = new SafeInitNodeStateListener(this.delegate, false);
        wrapper.onAdd(this.node);
        wrapper.onUp(this.node);
        wrapper.onSessionReady(this.session);
        wrapper.onDown(this.node);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.delegate});
        ((NodeStateListener)inOrder.verify((Object)this.delegate)).onSessionReady(this.session);
        ((NodeStateListener)inOrder.verify((Object)this.delegate)).onDown(this.node);
    }
}

