/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.data;

import com.datastax.oss.driver.TestDataProviders;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class CqlDurationTest {
    @Test
    @UseDataProvider(location={TestDataProviders.class}, value="locales")
    public void should_parse_from_string_with_standard_pattern(Locale locale) {
        Locale def = Locale.getDefault();
        try {
            Locale.setDefault(locale);
            Assertions.assertThat((Object)CqlDuration.from((String)"1y2mo")).isEqualTo((Object)CqlDuration.newInstance((int)14, (int)0, (long)0L));
            Assertions.assertThat((Object)CqlDuration.from((String)"-1y2mo")).isEqualTo((Object)CqlDuration.newInstance((int)-14, (int)0, (long)0L));
            Assertions.assertThat((Object)CqlDuration.from((String)"1Y2MO")).isEqualTo((Object)CqlDuration.newInstance((int)14, (int)0, (long)0L));
            Assertions.assertThat((Object)CqlDuration.from((String)"2w")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)14, (long)0L));
            Assertions.assertThat((Object)CqlDuration.from((String)"2d10h")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)2, (long)36000000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"2d")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)2, (long)0L));
            Assertions.assertThat((Object)CqlDuration.from((String)"30h")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)108000000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"30h20m")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)109200000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"20m")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)1200000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"56s")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)56000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"567ms")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)567000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"1950us")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)1950000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"1950\u00b5s")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)1950000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"1950000ns")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)1950000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"1950000NS")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)1950000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"-1950000ns")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)-1950000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"1y3mo2h10m")).isEqualTo((Object)CqlDuration.newInstance((int)15, (int)0, (long)7800000000000L));
        }
        finally {
            Locale.setDefault(def);
        }
    }

    @Test
    @UseDataProvider(location={TestDataProviders.class}, value="locales")
    public void should_parse_from_string_with_iso8601_pattern(Locale locale) {
        Locale def = Locale.getDefault();
        try {
            Locale.setDefault(locale);
            Assertions.assertThat((Object)CqlDuration.from((String)"P1Y2D")).isEqualTo((Object)CqlDuration.newInstance((int)12, (int)2, (long)0L));
            Assertions.assertThat((Object)CqlDuration.from((String)"P1Y2M")).isEqualTo((Object)CqlDuration.newInstance((int)14, (int)0, (long)0L));
            Assertions.assertThat((Object)CqlDuration.from((String)"P2W")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)14, (long)0L));
            Assertions.assertThat((Object)CqlDuration.from((String)"P1YT2H")).isEqualTo((Object)CqlDuration.newInstance((int)12, (int)0, (long)7200000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"-P1Y2M")).isEqualTo((Object)CqlDuration.newInstance((int)-14, (int)0, (long)0L));
            Assertions.assertThat((Object)CqlDuration.from((String)"P2D")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)2, (long)0L));
            Assertions.assertThat((Object)CqlDuration.from((String)"PT30H")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)108000000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"PT30H20M")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)109200000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"PT20M")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)1200000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"PT56S")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)56000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"P1Y3MT2H10M")).isEqualTo((Object)CqlDuration.newInstance((int)15, (int)0, (long)7800000000000L));
        }
        finally {
            Locale.setDefault(def);
        }
    }

    @Test
    @UseDataProvider(location={TestDataProviders.class}, value="locales")
    public void should_parse_from_string_with_iso8601_alternative_pattern(Locale locale) {
        Locale def = Locale.getDefault();
        try {
            Locale.setDefault(locale);
            Assertions.assertThat((Object)CqlDuration.from((String)"P0001-00-02T00:00:00")).isEqualTo((Object)CqlDuration.newInstance((int)12, (int)2, (long)0L));
            Assertions.assertThat((Object)CqlDuration.from((String)"P0001-02-00T00:00:00")).isEqualTo((Object)CqlDuration.newInstance((int)14, (int)0, (long)0L));
            Assertions.assertThat((Object)CqlDuration.from((String)"P0001-00-00T02:00:00")).isEqualTo((Object)CqlDuration.newInstance((int)12, (int)0, (long)7200000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"-P0001-02-00T00:00:00")).isEqualTo((Object)CqlDuration.newInstance((int)-14, (int)0, (long)0L));
            Assertions.assertThat((Object)CqlDuration.from((String)"P0000-00-02T00:00:00")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)2, (long)0L));
            Assertions.assertThat((Object)CqlDuration.from((String)"P0000-00-00T30:00:00")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)108000000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"P0000-00-00T30:20:00")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)109200000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"P0000-00-00T00:20:00")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)1200000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"P0000-00-00T00:00:56")).isEqualTo((Object)CqlDuration.newInstance((int)0, (int)0, (long)56000000000L));
            Assertions.assertThat((Object)CqlDuration.from((String)"P0001-03-00T02:10:00")).isEqualTo((Object)CqlDuration.newInstance((int)15, (int)0, (long)7800000000000L));
        }
        finally {
            Locale.setDefault(def);
        }
    }

    @Test
    public void should_fail_to_parse_invalid_durations() {
        this.assertInvalidDuration("9223372036854775807d", "Invalid duration. The total number of days must be less or equal to 2147483647");
        this.assertInvalidDuration("2\u00b5", "Unable to convert '2\u00b5' to a duration");
        this.assertInvalidDuration("-2\u00b5", "Unable to convert '2\u00b5' to a duration");
        this.assertInvalidDuration("12.5s", "Unable to convert '12.5s' to a duration");
        this.assertInvalidDuration("2m12.5s", "Unable to convert '2m12.5s' to a duration");
        this.assertInvalidDuration("2m-12s", "Unable to convert '2m-12s' to a duration");
        this.assertInvalidDuration("12s3s", "Invalid duration. The seconds are specified multiple times");
        this.assertInvalidDuration("12s3m", "Invalid duration. The seconds should be after minutes");
        this.assertInvalidDuration("1Y3M4D", "Invalid duration. The minutes should be after days");
        this.assertInvalidDuration("P2Y3W", "Unable to convert 'P2Y3W' to a duration");
        this.assertInvalidDuration("P0002-00-20", "Unable to convert 'P0002-00-20' to a duration");
    }

    private void assertInvalidDuration(String duration, String expectedErrorMessage) {
        try {
            CqlDuration.from((String)duration);
            Assertions.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo(expectedErrorMessage);
        }
    }

    @Test
    public void should_get_by_unit() {
        CqlDuration duration = CqlDuration.from((String)"3mo2d15s");
        Assertions.assertThat((long)duration.get((TemporalUnit)ChronoUnit.MONTHS)).isEqualTo(3L);
        Assertions.assertThat((long)duration.get((TemporalUnit)ChronoUnit.DAYS)).isEqualTo(2L);
        Assertions.assertThat((long)duration.get((TemporalUnit)ChronoUnit.NANOS)).isEqualTo(15000000000L);
        Assertions.assertThatThrownBy(() -> duration.get((TemporalUnit)ChronoUnit.YEARS)).isInstanceOf(UnsupportedTemporalTypeException.class);
    }

    @Test
    public void should_add_to_temporal() {
        ZonedDateTime dateTime = ZonedDateTime.parse("2018-10-04T00:00-07:00[America/Los_Angeles]");
        Assertions.assertThat((ZonedDateTime)dateTime.plus((TemporalAmount)CqlDuration.from((String)"1mo"))).isEqualTo("2018-11-04T00:00-07:00[America/Los_Angeles]");
        Assertions.assertThat((ZonedDateTime)dateTime.plus((TemporalAmount)CqlDuration.from((String)"1mo1h10s"))).isEqualTo("2018-11-04T01:00:10-07:00[America/Los_Angeles]");
        Assertions.assertThat((ZonedDateTime)dateTime.plus((TemporalAmount)CqlDuration.from((String)"1mo3h"))).isEqualTo("2018-11-04T02:00-08:00[America/Los_Angeles]");
    }

    @Test
    public void should_subtract_from_temporal() {
        ZonedDateTime dateTime = ZonedDateTime.parse("2018-10-04T00:00-07:00[America/Los_Angeles]");
        Assertions.assertThat((ZonedDateTime)dateTime.minus((TemporalAmount)CqlDuration.from((String)"2mo"))).isEqualTo("2018-08-04T00:00-07:00[America/Los_Angeles]");
        Assertions.assertThat((ZonedDateTime)dateTime.minus((TemporalAmount)CqlDuration.from((String)"1h15s15ns"))).isEqualTo("2018-10-03T22:59:44.999999985-07:00[America/Los_Angeles]");
    }
}

