/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.Version;
import java.util.List;
import org.assertj.core.api.AbstractComparableAssert;

public class VersionAssert
extends AbstractComparableAssert<VersionAssert, Version> {
    public VersionAssert(Version actual) {
        super((Comparable)actual, VersionAssert.class);
    }

    public VersionAssert hasMajorMinorPatch(int major, int minor, int patch) {
        Assertions.assertThat((int)((Version)this.actual).getMajor()).isEqualTo(major);
        Assertions.assertThat((int)((Version)this.actual).getMinor()).isEqualTo(minor);
        Assertions.assertThat((int)((Version)this.actual).getPatch()).isEqualTo(patch);
        return this;
    }

    public VersionAssert hasDsePatch(int dsePatch) {
        Assertions.assertThat((int)((Version)this.actual).getDSEPatch()).isEqualTo(dsePatch);
        return this;
    }

    public VersionAssert hasPreReleaseLabels(String ... labels) {
        Assertions.assertThat((List)((Version)this.actual).getPreReleaseLabels()).containsExactly((Object[])labels);
        return this;
    }

    public VersionAssert hasNoPreReleaseLabels() {
        Assertions.assertThat((List)((Version)this.actual).getPreReleaseLabels()).isNull();
        return this;
    }

    public VersionAssert hasBuildLabel(String label) {
        Assertions.assertThat((String)((Version)this.actual).getBuildLabel()).isEqualTo(label);
        return this;
    }

    public VersionAssert hasNextStable(String version) {
        Assertions.assertThat(((Version)this.actual).nextStable()).isEqualTo(Version.parse((String)version));
        return this;
    }

    public VersionAssert hasToString(String string) {
        Assertions.assertThat((String)((Version)this.actual).toString()).isEqualTo(string);
        return this;
    }
}

