/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core;

import com.datastax.oss.driver.TestDataProviders;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class CqlIdentifierTest {
    @Test
    public void should_build_from_internal() {
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"foo").asInternal()).isEqualTo("foo");
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"Foo").asInternal()).isEqualTo("Foo");
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"foo bar").asInternal()).isEqualTo("foo bar");
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"foo\"bar").asInternal()).isEqualTo("foo\"bar");
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"create").asInternal()).isEqualTo("create");
    }

    @Test
    @UseDataProvider(location={TestDataProviders.class}, value="locales")
    public void should_build_from_valid_cql(Locale locale) {
        Locale def = Locale.getDefault();
        try {
            Locale.setDefault(locale);
            Assertions.assertThat((String)CqlIdentifier.fromCql((String)"foo").asInternal()).isEqualTo("foo");
            Assertions.assertThat((String)CqlIdentifier.fromCql((String)"Foo").asInternal()).isEqualTo("foo");
            Assertions.assertThat((String)CqlIdentifier.fromCql((String)"\"Foo\"").asInternal()).isEqualTo("Foo");
            Assertions.assertThat((String)CqlIdentifier.fromCql((String)"\"foo bar\"").asInternal()).isEqualTo("foo bar");
            Assertions.assertThat((String)CqlIdentifier.fromCql((String)"\"foo\"\"bar\"").asInternal()).isEqualTo("foo\"bar");
            Assertions.assertThat((String)CqlIdentifier.fromCql((String)"\"create\"").asInternal()).isEqualTo("create");
            Assertions.assertThat((String)CqlIdentifier.fromCql((String)"TITLE").asInternal()).isEqualTo("title");
        }
        finally {
            Locale.setDefault(def);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_build_from_valid_cql_if_special_characters() {
        CqlIdentifier.fromCql((String)"foo bar");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_build_from_valid_cql_if_reserved_keyword() {
        CqlIdentifier.fromCql((String)"Create");
    }

    @Test
    public void should_format_as_cql() {
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"foo").asCql(false)).isEqualTo("\"foo\"");
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"Foo").asCql(false)).isEqualTo("\"Foo\"");
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"foo bar").asCql(false)).isEqualTo("\"foo bar\"");
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"foo\"bar").asCql(false)).isEqualTo("\"foo\"\"bar\"");
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"create").asCql(false)).isEqualTo("\"create\"");
    }

    @Test
    public void should_format_as_pretty_cql() {
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"foo").asCql(true)).isEqualTo("foo");
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"Foo").asCql(true)).isEqualTo("\"Foo\"");
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"foo bar").asCql(true)).isEqualTo("\"foo bar\"");
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"foo\"bar").asCql(true)).isEqualTo("\"foo\"\"bar\"");
        Assertions.assertThat((String)CqlIdentifier.fromInternal((String)"create").asCql(true)).isEqualTo("\"create\"");
    }
}

