/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core;

import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.ReadTimeoutException;
import com.datastax.oss.driver.api.core.servererrors.UnavailableException;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AllNodesFailedExceptionTest {
    @Mock(name="node1")
    private Node node1;
    @Mock(name="node2")
    private Node node2;

    @Test
    public void should_create_instance_from_map_of_first_errors() {
        UnavailableException e1 = new UnavailableException(this.node1, ConsistencyLevel.QUORUM, 2, 1);
        ReadTimeoutException e2 = new ReadTimeoutException(this.node2, ConsistencyLevel.QUORUM, 2, 1, false);
        ImmutableMap errors = ImmutableMap.of((Object)this.node1, (Object)e1, (Object)this.node2, (Object)e2);
        AllNodesFailedException e = AllNodesFailedException.fromErrors((Map)errors);
        Assertions.assertThat((Throwable)e).hasMessage("All 2 node(s) tried for the query failed (showing first 2 nodes, use getAllErrors() for more): node1: [%s], node2: [%s]", new Object[]{e1, e2});
        Assertions.assertThat((Map)e.getAllErrors()).hasEntrySatisfying((Object)this.node1, list -> Assertions.assertThat((List)list).containsExactly((Object[])new Throwable[]{e1}));
        Assertions.assertThat((Map)e.getAllErrors()).hasEntrySatisfying((Object)this.node2, list -> Assertions.assertThat((List)list).containsExactly((Object[])new Throwable[]{e2}));
        Assertions.assertThat((Map)e.getErrors()).containsEntry((Object)this.node1, (Object)e1);
        Assertions.assertThat((Map)e.getErrors()).containsEntry((Object)this.node2, (Object)e2);
        Assertions.assertThat((Throwable)e).hasSuppressedException((Throwable)e1).hasSuppressedException((Throwable)e2);
    }

    @Test
    public void should_create_instance_from_list_of_all_errors() {
        UnavailableException e1a = new UnavailableException(this.node1, ConsistencyLevel.QUORUM, 2, 1);
        ReadTimeoutException e1b = new ReadTimeoutException(this.node1, ConsistencyLevel.QUORUM, 2, 1, false);
        ReadTimeoutException e2a = new ReadTimeoutException(this.node2, ConsistencyLevel.QUORUM, 2, 1, false);
        ImmutableList errors = ImmutableList.of((Object)MapEntry.entry((Object)this.node1, (Object)e1a), (Object)MapEntry.entry((Object)this.node1, (Object)e1b), (Object)MapEntry.entry((Object)this.node2, (Object)e2a));
        AllNodesFailedException e = AllNodesFailedException.fromErrors((List)errors);
        Assertions.assertThat((Throwable)e).hasMessage("All 2 node(s) tried for the query failed (showing first 2 nodes, use getAllErrors() for more): node1: [%s, %s], node2: [%s]", new Object[]{e1a, e1b, e2a});
        Assertions.assertThat((Map)e.getAllErrors()).hasEntrySatisfying((Object)this.node1, list -> Assertions.assertThat((List)list).containsExactly((Object[])new Throwable[]{e1a, e1b}));
        Assertions.assertThat((Map)e.getAllErrors()).hasEntrySatisfying((Object)this.node2, list -> Assertions.assertThat((List)list).containsExactly((Object[])new Throwable[]{e2a}));
        Assertions.assertThat((Map)e.getErrors()).containsEntry((Object)this.node1, (Object)e1a);
        Assertions.assertThat((Map)e.getErrors()).containsEntry((Object)this.node2, (Object)e2a);
        Assertions.assertThat((Throwable)e).hasSuppressedException((Throwable)e1a).hasSuppressedException((Throwable)e1b).hasSuppressedException((Throwable)e2a);
    }
}

