/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.type.codec.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.api.core.data.geometry.Polygon;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPoint;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPolygon;
import com.datastax.dse.driver.internal.core.type.codec.geometry.GeometryCodecTest;
import com.datastax.dse.driver.internal.core.type.codec.geometry.PolygonCodec;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class PolygonCodecTest
extends GeometryCodecTest<Polygon, PolygonCodec> {
    private static Polygon polygon = new DefaultPolygon((Point)new DefaultPoint(30.0, 10.0), (Point)new DefaultPoint(10.0, 20.0), (Point)new DefaultPoint(20.0, 40.0), new Point[]{new DefaultPoint(40.0, 40.0)});

    public PolygonCodecTest() {
        super(new PolygonCodec());
    }

    @DataProvider
    public static Object[][] serde() {
        return new Object[][]{{null, null}, {polygon, polygon}};
    }

    @DataProvider
    public static Object[][] format() {
        return new Object[][]{{null, "NULL"}, {polygon, "'POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))'"}};
    }

    @DataProvider
    public static Object[][] parse() {
        return new Object[][]{{null, null}, {"", null}, {" ", null}, {"NULL", null}, {" NULL ", null}, {"'POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))'", polygon}, {" ' Polygon ( ( 30 10, 40 40, 20 40, 10 20, 30 10 ) ) ' ", polygon}};
    }

    @Override
    @Test
    @UseDataProvider(value="format")
    public void should_format(Polygon input, String expected) {
        super.should_format(input, expected);
    }

    @Override
    @Test
    @UseDataProvider(value="parse")
    public void should_parse(String input, Polygon expected) {
        super.should_parse(input, expected);
    }
}

