/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.dse.driver.internal.core.insights.ReconnectionPolicyInfoFinder;
import com.datastax.dse.driver.internal.core.insights.schema.ReconnectionPolicyInfo;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.internal.core.connection.ConstantReconnectionPolicy;
import com.datastax.oss.driver.internal.core.connection.ExponentialReconnectionPolicy;
import java.time.Duration;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.junit.Test;
import org.mockito.Mockito;

public class ReconnectionPolicyInfoFinderTest {
    @Test
    public void should_find_an_info_about_constant_reconnection_policy() {
        DriverExecutionProfile driverExecutionProfile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        Mockito.when((Object)driverExecutionProfile.getDuration((DriverOption)DefaultDriverOption.RECONNECTION_BASE_DELAY)).thenReturn((Object)Duration.ofMillis(100L));
        ReconnectionPolicy constantReconnectionPolicy = (ReconnectionPolicy)Mockito.mock(ConstantReconnectionPolicy.class);
        ReconnectionPolicyInfo reconnectionPolicyInfo = new ReconnectionPolicyInfoFinder().getReconnectionPolicyInfo(constantReconnectionPolicy, driverExecutionProfile);
        Assertions.assertThat((Map)reconnectionPolicyInfo.getOptions()).contains(new Map.Entry[]{MapEntry.entry((Object)"delayMs", (Object)100L)});
        Assertions.assertThat((String)reconnectionPolicyInfo.getType()).contains(new CharSequence[]{"ConstantReconnectionPolicy"});
    }

    @Test
    public void should_find_an_info_about_exponential_reconnection_policy() {
        ExponentialReconnectionPolicy exponentialReconnectionPolicy = (ExponentialReconnectionPolicy)Mockito.mock(ExponentialReconnectionPolicy.class);
        Mockito.when((Object)exponentialReconnectionPolicy.getBaseDelayMs()).thenReturn((Object)100L);
        Mockito.when((Object)exponentialReconnectionPolicy.getMaxAttempts()).thenReturn((Object)10L);
        Mockito.when((Object)exponentialReconnectionPolicy.getMaxDelayMs()).thenReturn((Object)200L);
        ReconnectionPolicyInfo reconnectionPolicyInfo = new ReconnectionPolicyInfoFinder().getReconnectionPolicyInfo((ReconnectionPolicy)exponentialReconnectionPolicy, null);
        Assertions.assertThat((Map)reconnectionPolicyInfo.getOptions()).contains(new Map.Entry[]{MapEntry.entry((Object)"baseDelayMs", (Object)100L)});
        Assertions.assertThat((Map)reconnectionPolicyInfo.getOptions()).contains(new Map.Entry[]{MapEntry.entry((Object)"maxAttempts", (Object)10L)});
        Assertions.assertThat((Map)reconnectionPolicyInfo.getOptions()).contains(new Map.Entry[]{MapEntry.entry((Object)"maxDelayMs", (Object)200L)});
        Assertions.assertThat((String)reconnectionPolicyInfo.getType()).contains(new CharSequence[]{"ExponentialReconnectionPolicy"});
    }
}

