/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.dse.driver.internal.core.insights.PackageUtil;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class PackageUtilTest {
    private static final String DEFAULT_PACKAGE = "default.package";

    @Test
    public void should_find_package_name_for_class() {
        TestClass testClass = new TestClass();
        String namespace = PackageUtil.getNamespace(testClass.getClass());
        Assertions.assertThat((String)namespace).isEqualTo("com.datastax.dse.driver.internal.core.insights");
    }

    @Test
    @UseDataProvider(value="packagesProvider")
    public void should_get_full_package_or_return_default(String fullClassSetting, String expected) {
        String result = PackageUtil.getFullPackageOrDefault((String)fullClassSetting, (String)DEFAULT_PACKAGE);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    @UseDataProvider(value="classesProvider")
    public void should_get_class_name_from_full_class_setting(String fullClassSetting, String expected) {
        String result = PackageUtil.getClassName((String)fullClassSetting);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @DataProvider
    public static Object[][] packagesProvider() {
        return new Object[][]{{"com.P", "com"}, {"ClassName", DEFAULT_PACKAGE}, {"", DEFAULT_PACKAGE}, {"com.p.a.2.x.12.Class", "com.p.a.2.x.12"}};
    }

    @DataProvider
    public static Object[][] classesProvider() {
        return new Object[][]{{"com.P", "P"}, {"ClassName", "ClassName"}, {"", ""}, {"com.p.a.2.x.12.Class", "Class"}};
    }

    private static class TestClass {
        private TestClass() {
        }
    }
}

