/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.internal.core.insights.ConfigAntiPatternsFinder;
import com.datastax.dse.driver.internal.core.insights.DataCentersFinder;
import com.datastax.dse.driver.internal.core.insights.ExecutionProfileMockUtil;
import com.datastax.dse.driver.internal.core.insights.ExecutionProfilesInfoFinder;
import com.datastax.dse.driver.internal.core.insights.InsightsClient;
import com.datastax.dse.driver.internal.core.insights.PlatformInfoFinder;
import com.datastax.dse.driver.internal.core.insights.ReconnectionPolicyInfoFinder;
import com.datastax.dse.driver.internal.core.insights.configuration.InsightsConfiguration;
import com.datastax.dse.driver.internal.core.insights.schema.AuthProviderType;
import com.datastax.dse.driver.internal.core.insights.schema.Insight;
import com.datastax.dse.driver.internal.core.insights.schema.InsightMetadata;
import com.datastax.dse.driver.internal.core.insights.schema.InsightType;
import com.datastax.dse.driver.internal.core.insights.schema.InsightsPlatformInfo;
import com.datastax.dse.driver.internal.core.insights.schema.InsightsStartupData;
import com.datastax.dse.driver.internal.core.insights.schema.InsightsStatusData;
import com.datastax.dse.driver.internal.core.insights.schema.LoadBalancingInfo;
import com.datastax.dse.driver.internal.core.insights.schema.PoolSizeByHostDistance;
import com.datastax.dse.driver.internal.core.insights.schema.ReconnectionPolicyInfo;
import com.datastax.dse.driver.internal.core.insights.schema.SSL;
import com.datastax.dse.driver.internal.core.insights.schema.SessionStateForNode;
import com.datastax.dse.driver.internal.core.insights.schema.SpecificExecutionProfile;
import com.datastax.dse.driver.internal.core.insights.schema.SpeculativeExecutionInfo;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.control.ControlConnection;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.internal.core.session.PoolManager;
import com.datastax.oss.driver.shaded.guava.common.base.Suppliers;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import io.netty.channel.DefaultEventLoop;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=DataProviderRunner.class)
public class InsightsClientTest {
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final Map<String, Object> EMPTY_OBJECT_MAP = Collections.emptyMap();
    private static final Supplier<Long> MOCK_TIME_SUPPLIER = Suppliers.ofInstance((Object)1L);
    private static final InsightsConfiguration INSIGHTS_CONFIGURATION = new InsightsConfiguration(true, 300000L, (EventExecutor)new DefaultEventLoop());

    @Test
    public void should_construct_json_event_startup_message() throws IOException {
        DefaultDriverContext context = this.mockDefaultDriverContext();
        PlatformInfoFinder platformInfoFinder = (PlatformInfoFinder)Mockito.mock(PlatformInfoFinder.class);
        InsightsPlatformInfo.OS os = new InsightsPlatformInfo.OS("linux", "1.2", "x64");
        InsightsPlatformInfo.CPUS cpus = new InsightsPlatformInfo.CPUS(8, "intel i7");
        ImmutableMap javaDeps = ImmutableMap.of((Object)"version", (Object)new InsightsPlatformInfo.RuntimeAndCompileTimeVersions("1.8.0", "1.8.0", false));
        ImmutableMap runtimeInfo = ImmutableMap.of((Object)"java", (Object)javaDeps);
        InsightsPlatformInfo insightsPlatformInfo = new InsightsPlatformInfo(os, cpus, (Map)runtimeInfo);
        Mockito.when((Object)platformInfoFinder.getInsightsPlatformInfo()).thenReturn((Object)insightsPlatformInfo);
        ConfigAntiPatternsFinder configAntiPatternsFinder = (ConfigAntiPatternsFinder)Mockito.mock(ConfigAntiPatternsFinder.class);
        Mockito.when((Object)configAntiPatternsFinder.findAntiPatterns((InternalDriverContext)ArgumentMatchers.any(DefaultDriverContext.class))).thenReturn((Object)ImmutableMap.of((Object)"contactPointsMultipleDCs", (Object)"Contact points contain hosts from multiple data centers"));
        DataCentersFinder dataCentersFinder = (DataCentersFinder)Mockito.mock(DataCentersFinder.class);
        Mockito.when((Object)dataCentersFinder.getDataCenters((InternalDriverContext)ArgumentMatchers.any(DefaultDriverContext.class))).thenReturn((Object)Sets.newHashSet((Object[])new String[]{"dc1", "dc2"}));
        ReconnectionPolicyInfoFinder reconnectionPolicyInfoFinder = (ReconnectionPolicyInfoFinder)Mockito.mock(ReconnectionPolicyInfoFinder.class);
        Mockito.when((Object)reconnectionPolicyInfoFinder.getReconnectionPolicyInfo((ReconnectionPolicy)ArgumentMatchers.any(), (DriverExecutionProfile)ArgumentMatchers.any())).thenReturn((Object)new ReconnectionPolicyInfo("reconnection-policy-a", (Map)ImmutableMap.of((Object)"opt-a", (Object)1), "com.datastax.dse"));
        InsightsClient insightsClient = new InsightsClient((InternalDriverContext)context, MOCK_TIME_SUPPLIER, INSIGHTS_CONFIGURATION, platformInfoFinder, reconnectionPolicyInfoFinder, new ExecutionProfilesInfoFinder(), configAntiPatternsFinder, dataCentersFinder, EMPTY_STACK_TRACE);
        String startupMessage = insightsClient.createStartupMessage();
        Insight insight = (Insight)new ObjectMapper().readValue(startupMessage, (TypeReference)new TypeReference<Insight<InsightsStartupData>>(){});
        Assertions.assertThat((Object)insight.getMetadata()).isEqualTo((Object)new InsightMetadata("driver.startup", 1L, (Map)ImmutableMap.of((Object)"language", (Object)"java"), InsightType.EVENT, "v1"));
        InsightsStartupData insightData = (InsightsStartupData)insight.getInsightData();
        Assertions.assertThat((String)insightData.getClientId()).isEqualTo("client-id");
        Assertions.assertThat((String)insightData.getSessionId()).isNotNull();
        Assertions.assertThat((String)insightData.getDriverName()).isEqualTo("DataStax Enterprise Java Driver");
        Assertions.assertThat((String)insightData.getDriverVersion()).isNotEmpty();
        Assertions.assertThat((String)insightData.getApplicationName()).isEqualTo("app-name");
        Assertions.assertThat((String)insightData.getApplicationVersion()).isEqualTo("1.0.0");
        Assertions.assertThat((boolean)insightData.isApplicationNameWasGenerated()).isEqualTo(false);
        Assertions.assertThat((Map)insightData.getContactPoints()).isEqualTo((Object)ImmutableMap.of((Object)"localhost", Collections.singletonList("127.0.0.1:9999")));
        Assertions.assertThat((String)insightData.getInitialControlConnection()).isEqualTo("127.0.0.1:10");
        Assertions.assertThat((String)insightData.getLocalAddress()).isEqualTo("127.0.0.1");
        Assertions.assertThat((String)insightData.getHostName()).isNotEmpty();
        Assertions.assertThat((int)insightData.getProtocolVersion()).isEqualTo(DseProtocolVersion.DSE_V2.getCode());
        Assertions.assertThat((Map)insightData.getExecutionProfiles()).isEqualTo((Object)ImmutableMap.of((Object)"default", (Object)new SpecificExecutionProfile(Integer.valueOf(100), new LoadBalancingInfo("LoadBalancingPolicyImpl", (Map)ImmutableMap.of((Object)"localDataCenter", (Object)"local-dc", (Object)"filterFunction", (Object)true), "com.datastax.oss.driver.internal.core.loadbalancing"), new SpeculativeExecutionInfo("SpeculativeExecutionImpl", (Map)ImmutableMap.of((Object)"maxSpeculativeExecutions", (Object)100, (Object)"delay", (Object)20), "com.datastax.oss.driver.internal.core.specex"), "LOCAL_ONE", "SERIAL", (Map)ImmutableMap.of((Object)"source", (Object)"src-graph")), (Object)"non-default", (Object)new SpecificExecutionProfile(Integer.valueOf(50), null, null, null, null, null)));
        Assertions.assertThat((Object)insightData.getPoolSizeByHostDistance()).isEqualTo((Object)new PoolSizeByHostDistance(2, 1, 0));
        Assertions.assertThat((long)insightData.getHeartbeatInterval()).isEqualTo(100L);
        Assertions.assertThat((String)insightData.getCompression()).isEqualTo("none");
        Assertions.assertThat((Object)insightData.getReconnectionPolicy()).isEqualTo((Object)new ReconnectionPolicyInfo("reconnection-policy-a", (Map)ImmutableMap.of((Object)"opt-a", (Object)1), "com.datastax.dse"));
        Assertions.assertThat((Object)insightData.getSsl()).isEqualTo((Object)new SSL(true, false));
        Assertions.assertThat((Object)insightData.getAuthProvider()).isEqualTo((Object)new AuthProviderType("AuthProviderImpl", "com.datastax.oss.driver.internal.core.auth"));
        Assertions.assertThat((Map)insightData.getOtherOptions()).isEqualTo(EMPTY_OBJECT_MAP);
        Assertions.assertThat((Object)insightData.getPlatformInfo()).isEqualTo((Object)insightsPlatformInfo);
        Assertions.assertThat((Map)insightData.getConfigAntiPatterns()).isEqualTo((Object)ImmutableMap.of((Object)"contactPointsMultipleDCs", (Object)"Contact points contain hosts from multiple data centers"));
        Assertions.assertThat((long)insightData.getPeriodicStatusInterval()).isEqualTo(300L);
        Assertions.assertThat((Iterable)insightData.getDataCenters()).isEqualTo((Object)Sets.newHashSet((Object[])new String[]{"dc1", "dc2"}));
    }

    @Test
    public void should_group_contact_points_by_host_name() {
        ImmutableSet contactPoints = ImmutableSet.of((Object)InetSocketAddress.createUnresolved("127.0.0.1", 8080), (Object)InetSocketAddress.createUnresolved("127.0.0.1", 8081), (Object)InetSocketAddress.createUnresolved("127.0.0.2", 8081));
        ImmutableMap expected = ImmutableMap.of((Object)"127.0.0.1", (Object)ImmutableList.of((Object)"127.0.0.1:8080", (Object)"127.0.0.1:8081"), (Object)"127.0.0.2", (Object)ImmutableList.of((Object)"127.0.0.2:8081"));
        Map resolvedContactPoints = InsightsClient.getResolvedContactPoints((Set)contactPoints);
        Assertions.assertThat((Map)resolvedContactPoints).isEqualTo((Object)expected);
    }

    @Test
    public void should_construct_json_event_status_message() throws IOException {
        InsightsClient insightsClient = new InsightsClient((InternalDriverContext)this.mockDefaultDriverContext(), MOCK_TIME_SUPPLIER, INSIGHTS_CONFIGURATION, null, null, null, null, null, EMPTY_STACK_TRACE);
        String statusMessage = insightsClient.createStatusMessage();
        Insight insight = (Insight)new ObjectMapper().readValue(statusMessage, (TypeReference)new TypeReference<Insight<InsightsStatusData>>(){});
        Assertions.assertThat((Object)insight.getMetadata()).isEqualTo((Object)new InsightMetadata("driver.status", 1L, (Map)ImmutableMap.of((Object)"language", (Object)"java"), InsightType.EVENT, "v1"));
        InsightsStatusData insightData = (InsightsStatusData)insight.getInsightData();
        Assertions.assertThat((String)insightData.getClientId()).isEqualTo("client-id");
        Assertions.assertThat((String)insightData.getSessionId()).isNotNull();
        Assertions.assertThat((String)insightData.getControlConnection()).isEqualTo("127.0.0.1:10");
        Assertions.assertThat((Map)insightData.getConnectedNodes()).isEqualTo((Object)ImmutableMap.of((Object)"127.0.0.1:10", (Object)new SessionStateForNode(Integer.valueOf(1), Integer.valueOf(10)), (Object)"127.0.0.1:20", (Object)new SessionStateForNode(Integer.valueOf(2), Integer.valueOf(20))));
    }

    @Test
    public void should_schedule_task_with_initial_delay() {
        AtomicInteger counter = new AtomicInteger();
        Runnable runnable = counter::incrementAndGet;
        InsightsClient.scheduleInsightsTask((long)100L, (ScheduledExecutorService)Executors.newScheduledThreadPool(1), (Runnable)runnable);
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> counter.get() >= 1);
    }

    @Test
    @UseDataProvider(value="stackTraceProvider")
    public void should_get_caller_of_create_cluster(StackTraceElement[] stackTrace, String expected) {
        String result = InsightsClient.getClusterCreateCaller((StackTraceElement[])stackTrace);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @Test
    public void should_execute_should_send_event_check_only_once() throws UnknownHostException, InterruptedException {
        InsightsConfiguration insightsConfiguration = (InsightsConfiguration)Mockito.mock(InsightsConfiguration.class);
        Mockito.when((Object)insightsConfiguration.isMonitorReportingEnabled()).thenReturn((Object)true);
        Mockito.when((Object)insightsConfiguration.getStatusEventDelayMillis()).thenReturn((Object)10L);
        Mockito.when((Object)insightsConfiguration.getExecutor()).thenReturn((Object)new DefaultEventLoop());
        InsightsClient insightsClient = new InsightsClient((InternalDriverContext)this.mockDefaultDriverContext(), MOCK_TIME_SUPPLIER, insightsConfiguration, null, null, null, null, null, EMPTY_STACK_TRACE);
        insightsClient.scheduleStatusMessageSend();
        insightsClient.sendStatusMessage();
        insightsClient.sendStatusMessage();
        insightsClient.sendStatusMessage();
        ((InsightsConfiguration)Mockito.verify((Object)insightsConfiguration, (VerificationMode)Mockito.times((int)1))).isMonitorReportingEnabled();
    }

    @DataProvider
    public static Object[][] stackTraceProvider() {
        StackTraceElement[] onlyInitCall = new StackTraceElement[]{new StackTraceElement("com.datastax.oss.driver.internal.core.context.DefaultDriverContext", "<init>", "DefaultDriverContext.java", 94)};
        StackTraceElement[] stackTraceElementsWithoutInitCall = new StackTraceElement[]{new StackTraceElement("java.lang.Thread", "getStackTrace", "Thread.java", 1559), new StackTraceElement("com.datastax.driver.core.InsightsClient", "getClusterCreateCaller", "InsightsClient.java", 302)};
        StackTraceElement[] stackTraceWithOneInitCall = new StackTraceElement[]{new StackTraceElement("java.lang.Thread", "getStackTrace", "Thread.java", 1559), new StackTraceElement("com.datastax.oss.driver.internal.core.context.DefaultDriverContext", "<init>", "DefaultDriverContext.java", 243)};
        StackTraceElement[] stackTraceWithOneInitCallAndCaller = new StackTraceElement[]{new StackTraceElement("java.lang.Thread", "getStackTrace", "Thread.java", 1559), new StackTraceElement("com.datastax.oss.driver.internal.core.context.DefaultDriverContext", "<init>", "DefaultDriverContext.java", 243), new StackTraceElement("com.example.ActualCallerNameApp", "main", "ActualCallerNameApp.java", 1)};
        StackTraceElement[] stackTraceWithTwoInitCallsAndCaller = new StackTraceElement[]{new StackTraceElement("java.lang.Thread", "getStackTrace", "Thread.java", 1559), new StackTraceElement("com.datastax.oss.driver.internal.core.context.DefaultDriverContext", "<init>", "DefaultDriverContext.java", 243), new StackTraceElement("com.datastax.oss.driver.api.core.session.SessionBuilder", "buildDefaultSessionAsync", "SessionBuilder.java", 300), new StackTraceElement("com.example.ActualCallerNameApp", "main", "ActualCallerNameApp.java", 1)};
        StackTraceElement[] stackTraceWithChainOfInitCalls = new StackTraceElement[]{new StackTraceElement("com.datastax.oss.driver.internal.core.context.DefaultDriverContext", "<init>", "DefaultDriverContext.java", 243), new StackTraceElement("com.datastax.oss.driver.api.core.session.SessionBuilder", "buildDefaultSessionAsync", "SessionBuilder.java", 332), new StackTraceElement("com.datastax.oss.driver.api.core.session.SessionBuilder", "buildAsync", "SessionBuilder.java", 291), new StackTraceElement("com.datastax.oss.driver.api.core.session.SessionBuilder", "build", "SessionBuilder.java", 306)};
        StackTraceElement[] stackTraceWithChainOfInitCallsAndCaller = new StackTraceElement[]{new StackTraceElement("java.lang.Thread", "getStackTrace", "Thread.java", 1559), new StackTraceElement("com.datastax.oss.driver.internal.core.context.DefaultDriverContext", "<init>", "DefaultDriverContext.java", 243), new StackTraceElement("com.datastax.oss.driver.api.core.session.SessionBuilder", "buildContext", "SessionBuilder.java", 687), new StackTraceElement("com.datastax.oss.driver.api.core.session.SessionBuilder", "buildDefaultSessionAsync", "SessionBuilder.java", 332), new StackTraceElement("com.datastax.oss.driver.api.core.session.SessionBuilder", "buildAsync", "SessionBuilder.java", 291), new StackTraceElement("com.datastax.oss.driver.api.core.session.SessionBuilder", "build", "SessionBuilder.java", 306), new StackTraceElement("com.example.ActualCallerNameApp", "main", "ActualCallerNameApp.java", 8)};
        return new Object[][]{{new StackTraceElement[0], "Default Java Application"}, {stackTraceElementsWithoutInitCall, "Default Java Application"}, {stackTraceWithOneInitCall, "Default Java Application"}, {onlyInitCall, "Default Java Application"}, {stackTraceWithOneInitCallAndCaller, "com.example.ActualCallerNameApp"}, {stackTraceWithTwoInitCallsAndCaller, "com.example.ActualCallerNameApp"}, {stackTraceWithChainOfInitCalls, "Default Java Application"}, {stackTraceWithChainOfInitCallsAndCaller, "com.example.ActualCallerNameApp"}};
    }

    private DefaultDriverContext mockDefaultDriverContext() throws UnknownHostException {
        DefaultDriverContext context = (DefaultDriverContext)Mockito.mock(DefaultDriverContext.class);
        this.mockConnectionPools(context);
        MetadataManager manager = (MetadataManager)Mockito.mock(MetadataManager.class);
        Mockito.when((Object)context.getMetadataManager()).thenReturn((Object)manager);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        Mockito.when((Object)manager.getMetadata()).thenReturn((Object)metadata);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getExtras()).thenReturn((Object)ImmutableMap.of((Object)"DSE_VERSION", (Object)Objects.requireNonNull(Version.parse((String)"6.0.5"))));
        Mockito.when((Object)metadata.getNodes()).thenReturn((Object)ImmutableMap.of((Object)UUID.randomUUID(), (Object)node));
        DriverExecutionProfile defaultExecutionProfile = ExecutionProfileMockUtil.mockDefaultExecutionProfile();
        DriverExecutionProfile nonDefaultExecutionProfile = ExecutionProfileMockUtil.mockNonDefaultRequestTimeoutExecutionProfile();
        HashMap<String, String> startupOptions = new HashMap<String, String>();
        startupOptions.put("CLIENT_ID", "client-id");
        startupOptions.put("APPLICATION_VERSION", "1.0.0");
        startupOptions.put("APPLICATION_NAME", "app-name");
        startupOptions.put("DRIVER_VERSION", "2.x");
        startupOptions.put("DRIVER_NAME", "DataStax Enterprise Java Driver");
        Mockito.when((Object)context.getStartupOptions()).thenReturn(startupOptions);
        Mockito.when((Object)context.getProtocolVersion()).thenReturn((Object)DseProtocolVersion.DSE_V2);
        DefaultNode contactPoint = (DefaultNode)Mockito.mock(DefaultNode.class);
        EndPoint contactEndPoint = (EndPoint)Mockito.mock(EndPoint.class);
        Mockito.when((Object)contactEndPoint.resolve()).thenReturn((Object)new InetSocketAddress("127.0.0.1", 9999));
        Mockito.when((Object)contactPoint.getEndPoint()).thenReturn((Object)contactEndPoint);
        Mockito.when((Object)manager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)contactPoint));
        DriverConfig driverConfig = (DriverConfig)Mockito.mock(DriverConfig.class);
        Mockito.when((Object)context.getConfig()).thenReturn((Object)driverConfig);
        ImmutableMap profiles = ImmutableMap.of((Object)"default", (Object)defaultExecutionProfile, (Object)"non-default", (Object)nonDefaultExecutionProfile);
        Mockito.when((Object)driverConfig.getProfiles()).thenReturn((Object)profiles);
        Mockito.when((Object)driverConfig.getDefaultProfile()).thenReturn((Object)defaultExecutionProfile);
        ControlConnection controlConnection = (ControlConnection)Mockito.mock(ControlConnection.class);
        DriverChannel channel = (DriverChannel)Mockito.mock(DriverChannel.class);
        EndPoint controlConnectionEndpoint = (EndPoint)Mockito.mock(EndPoint.class);
        Mockito.when((Object)controlConnectionEndpoint.resolve()).thenReturn((Object)new InetSocketAddress("127.0.0.1", 10));
        Mockito.when((Object)channel.getEndPoint()).thenReturn((Object)controlConnectionEndpoint);
        Mockito.when((Object)channel.localAddress()).thenReturn((Object)new InetSocketAddress("127.0.0.1", 10));
        Mockito.when((Object)controlConnection.channel()).thenReturn((Object)channel);
        Mockito.when((Object)context.getControlConnection()).thenReturn((Object)controlConnection);
        return context;
    }

    private void mockConnectionPools(DefaultDriverContext driverContext) {
        Node node1 = (Node)Mockito.mock(Node.class);
        EndPoint endPoint1 = (EndPoint)Mockito.mock(EndPoint.class);
        Mockito.when((Object)endPoint1.resolve()).thenReturn((Object)new InetSocketAddress("127.0.0.1", 10));
        Mockito.when((Object)node1.getEndPoint()).thenReturn((Object)endPoint1);
        Mockito.when((Object)node1.getOpenConnections()).thenReturn((Object)1);
        ChannelPool channelPool1 = (ChannelPool)Mockito.mock(ChannelPool.class);
        Mockito.when((Object)channelPool1.getInFlight()).thenReturn((Object)10);
        Node node2 = (Node)Mockito.mock(Node.class);
        EndPoint endPoint2 = (EndPoint)Mockito.mock(EndPoint.class);
        Mockito.when((Object)endPoint2.resolve()).thenReturn((Object)new InetSocketAddress("127.0.0.1", 20));
        Mockito.when((Object)node2.getEndPoint()).thenReturn((Object)endPoint2);
        Mockito.when((Object)node2.getOpenConnections()).thenReturn((Object)2);
        ChannelPool channelPool2 = (ChannelPool)Mockito.mock(ChannelPool.class);
        Mockito.when((Object)channelPool2.getInFlight()).thenReturn((Object)20);
        ImmutableMap channelPools = ImmutableMap.of((Object)node1, (Object)channelPool1, (Object)node2, (Object)channelPool2);
        PoolManager poolManager = (PoolManager)Mockito.mock(PoolManager.class);
        Mockito.when((Object)poolManager.getPools()).thenReturn((Object)channelPools);
        Mockito.when((Object)driverContext.getPoolManager()).thenReturn((Object)poolManager);
    }
}

