/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.dse.driver.internal.core.insights.AddressFormatter;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class AddressFormatterTest {
    @Test
    @UseDataProvider(value="addressesProvider")
    public void should_format_addresses(Object address, String expected) {
        String result = AddressFormatter.nullSafeToString((Object)address);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }

    @DataProvider
    public static Object[][] addressesProvider() throws UnknownHostException {
        return new Object[][]{{new InetSocketAddress(8888), "0.0.0.0:8888"}, {new InetSocketAddress("127.0.0.1", 8888), "127.0.0.1:8888"}, {InetSocketAddress.createUnresolved("127.0.0.2", 8080), "127.0.0.2:8080"}, {InetAddress.getByName("127.0.0.1"), "127.0.0.1"}};
    }
}

