/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.FluentGraphStatement;
import com.datastax.dse.driver.api.core.graph.GraphStatementBuilderBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class GraphStatementBuilderBaseTest {
    @Test
    public void should_use_timestamp_if_set() {
        MockGraphStatementBuilder builder = new MockGraphStatementBuilder();
        builder.setTimestamp(1L);
        Assertions.assertThat((long)builder.build().getTimestamp()).isEqualTo(1L);
    }

    @Test
    public void should_use_correct_default_timestamp_if_not_set() {
        MockGraphStatementBuilder builder = new MockGraphStatementBuilder();
        Assertions.assertThat((long)builder.build().getTimestamp()).isEqualTo(Long.MIN_VALUE);
    }

    private static class MockGraphStatementBuilder
    extends GraphStatementBuilderBase<MockGraphStatementBuilder, FluentGraphStatement> {
        private MockGraphStatementBuilder() {
        }

        @NonNull
        public FluentGraphStatement build() {
            FluentGraphStatement rv = (FluentGraphStatement)Mockito.mock(FluentGraphStatement.class);
            Mockito.when((Object)rv.getTimestamp()).thenReturn((Object)this.timestamp);
            return rv;
        }
    }
}

