/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;

public abstract class GraphResultSetTestBase {
    protected AsyncGraphResultSet mockPage(boolean nextPage, Integer ... data) {
        AsyncGraphResultSet page = (AsyncGraphResultSet)Mockito.mock(AsyncGraphResultSet.class);
        ExecutionInfo executionInfo = (ExecutionInfo)Mockito.mock(ExecutionInfo.class);
        Mockito.when((Object)page.getRequestExecutionInfo()).thenReturn((Object)executionInfo);
        if (nextPage) {
            Mockito.when((Object)page.hasMorePages()).thenReturn((Object)true);
            Mockito.when((Object)page.fetchNextPage()).thenReturn((Object)((CompletionStage)Mockito.spy(new CompletableFuture())));
        } else {
            Mockito.when((Object)page.hasMorePages()).thenReturn((Object)false);
            Mockito.when((Object)page.fetchNextPage()).thenThrow(new Throwable[]{new IllegalStateException()});
        }
        final LinkedList queue = Lists.newLinkedList(Arrays.asList(data));
        CountingIterator<GraphNode> iterator = new CountingIterator<GraphNode>(queue.size()){

            protected GraphNode computeNext() {
                Integer index = (Integer)queue.poll();
                return index == null ? (GraphNode)this.endOfData() : GraphResultSetTestBase.this.mockRow(index);
            }
        };
        Mockito.when((Object)page.currentPage()).thenReturn(() -> GraphResultSetTestBase.lambda$mockPage$0((CountingIterator)iterator));
        Mockito.when((Object)page.remaining()).thenAnswer(arg_0 -> GraphResultSetTestBase.lambda$mockPage$1((CountingIterator)iterator, arg_0));
        return page;
    }

    private GraphNode mockRow(int index) {
        GraphNode row = (GraphNode)Mockito.mock(GraphNode.class);
        Mockito.when((Object)row.asInt()).thenReturn((Object)index);
        return row;
    }

    protected static void complete(CompletionStage<AsyncGraphResultSet> stage, AsyncGraphResultSet result) {
        stage.toCompletableFuture().complete(result);
    }

    protected void assertNextRow(Iterator<GraphNode> iterator, int expectedValue) {
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        GraphNode row = iterator.next();
        Assertions.assertThat((int)row.asInt()).isEqualTo(expectedValue);
    }

    private static /* synthetic */ Object lambda$mockPage$1(CountingIterator iterator, InvocationOnMock invocation) throws Throwable {
        return iterator.remaining();
    }

    private static /* synthetic */ Iterator lambda$mockPage$0(CountingIterator iterator) {
        return iterator;
    }
}

